/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.sql.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class SqlStats
extends DefaultSectionStats {
    public AtomicReference<String> sqlString = new AtomicReference();
    private volatile int updatedRowCountOld;
    private volatile int readRowCountOld;
    private AtomicInteger updatedRowCount = new AtomicInteger(0);
    private AtomicInteger readRowCount = new AtomicInteger(0);
    private AtomicReference<String> slowTraceId = new AtomicReference();
    private AtomicReference<String> errorTraceId = new AtomicReference();
    private AtomicReference<String> lastError = new AtomicReference();
    private AtomicReference<String> lastTraceId = new AtomicReference();
    private AtomicReference<String> lastDBName = new AtomicReference();
    private AtomicInteger slowSqlCount = new AtomicInteger(0);

    public MonitorDataRow harvest(int[] newRanges) {
        int updatedRowCountNew = this.updatedRowCount.get();
        int readRowCountNew = this.readRowCount.get();
        MonitorDataRow sv = super.harvest(newRanges);
        if (sv != null) {
            sv.put((Object)"updatedRowCount", (Object)(updatedRowCountNew - this.updatedRowCountOld));
            sv.put((Object)"readRowCount", (Object)(readRowCountNew - this.readRowCountOld));
            sv.put((Object)"sqlString", (Object)this.sqlString.get());
            sv.put((Object)"slowTraceId", this.slowTraceId.getAndSet(null));
            sv.put((Object)"errorTraceId", this.errorTraceId.getAndSet(null));
            sv.put((Object)"lastError", this.lastError.getAndSet(null));
            sv.put((Object)"lastTraceId", this.lastTraceId.getAndSet(null));
            sv.put((Object)"lastDBName", this.lastDBName.getAndSet(null));
            sv.put((Object)"slowSqlCount", (Object)this.slowSqlCount.getAndSet(0));
            this.updatedRowCountOld = updatedRowCountNew;
            this.readRowCountOld = readRowCountNew;
            return sv;
        }
        return null;
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow sv = super.getStatus();
        sv.put((Object)"updatedRowCount", (Object)this.updatedRowCount.get());
        sv.put((Object)"readRowCount", (Object)this.readRowCount.get());
        sv.put((Object)"sqlString", (Object)this.sqlString.get());
        sv.put((Object)"slowTraceId", (Object)this.slowTraceId.get());
        sv.put((Object)"errorTraceId", (Object)this.errorTraceId.get());
        sv.put((Object)"lastError", (Object)this.lastError.get());
        sv.put((Object)"lastTraceId", (Object)this.lastTraceId.get());
        return sv;
    }

    public void onThrowable(Throwable t) {
        super.onThrowable(t);
        if (this.lastError.get() == null) {
            String s = ExceptionUtil.getThrowableStackTrace((Throwable)t, (boolean)ConfigManager.isHideExceptionMessage());
            this.lastError.set(s);
            String traceId = TraceCollector.getTraceId();
            if (traceId != null) {
                this.errorTraceId.set(traceId);
            }
        }
    }

    public boolean onFinally(long used, int updatedRowCount, int readRowCount, int slowSqlThreshold) {
        this.updatedRowCount.addAndGet(updatedRowCount);
        this.readRowCount.addAndGet(readRowCount);
        boolean isSlowTrace = super.onFinally(used);
        String traceId = TraceCollector.getTraceId();
        if (traceId != null) {
            this.lastTraceId.set(traceId);
            if (isSlowTrace) {
                this.slowTraceId.set(traceId);
            }
        }
        if (used / 1000000L > (long)slowSqlThreshold) {
            this.slowSqlCount.incrementAndGet();
        }
        return isSlowTrace;
    }

    public void setLastDBName(String dbName) {
        if (dbName != null) {
            this.lastDBName.set(dbName);
        }
    }
}

