/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.mysql.collector;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.otel.ConstantsTrace;
import com.lubanops.apm.bootstrap.otel.OtelSpanKind;
import com.lubanops.apm.bootstrap.plugin.mysql.collector.MysqlCollector;
import com.lubanops.apm.bootstrap.plugin.sql.Helper;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ResultSetAttribute;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlIdThreadLocal;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;

public class MysqlTrace {
    private static final Logger LOGGER = LogFactory.getLogger();

    public static void onStart(String className, String methodName, String sql, String originSql, Integer id) {
        SpanEvent spanEventReport;
        if (MysqlCollector.INSTANCE.isEnable() && (spanEventReport = TraceCollector.onStart((String)className, (String)methodName, (String)"Mysql", (String)sql, (OtelSpanKind)OtelSpanKind.CLIENT)) != null) {
            spanEventReport.addTag("sqlId", SqlIdThreadLocal.THREAD_LOCAL.get());
            spanEventReport.addTag("sql", sql, MysqlCollector.CONFIG.getSqlSize());
            if (originSql != null && MysqlCollector.CONFIG.isParseOriginSql()) {
                spanEventReport.addTag("originSql", originSql, MysqlCollector.CONFIG.getSqlSize());
            }
            if (id != null) {
                String dBName = Helper.CONNECTION_TARGET_MAP.getResource(id.intValue());
                spanEventReport.addTag("DBName", dBName);
                TraceCollector.addOtelAttribute((String)ConstantsTrace.AttributeDBConnectionString.toString(), (Object)dBName);
            }
            TraceCollector.addOtelAttribute((String)ConstantsTrace.AttributeDBSystem.toString(), (Object)ConstantsTrace.AttributeDBSystemMySQL.toString());
            TraceCollector.addOtelAttribute((String)ConstantsTrace.AttributeDBStatement.toString(), (Object)sql);
        }
    }

    public static void onError(Throwable e) {
        if (MysqlCollector.INSTANCE.isEnable()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public static void onFinally(int updateRowCount, int readRowCount, TransformAccess resultSet) {
        if (MysqlCollector.INSTANCE.isEnable()) {
            if (updateRowCount > 0) {
                TraceCollector.addTag((String)"updateRowCount", (String)String.valueOf(updateRowCount));
            }
            if (readRowCount > 0) {
                TraceCollector.addTag((String)"readRowCount", (String)String.valueOf(readRowCount));
            }
            if (readRowCount != 0 && MysqlCollector.CONFIG.isBodyDetail() && resultSet != null) {
                SpanEvent spanEvent = TraceCollector.onFinally((boolean)false);
                if (spanEvent != null) {
                    ResultSetAttribute resultSetAttribute = new ResultSetAttribute();
                    resultSetAttribute.setSpanEvent(spanEvent);
                    resultSet.setLopsAttribute((Object)resultSetAttribute);
                }
            } else {
                TraceCollector.onFinally();
            }
        }
    }
}

