/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.utils;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Date;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class ThreadUtils {
    private static ThreadMXBean tmx = ManagementFactory.getThreadMXBean();
    private static MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private static final Logger LOGGER = LogFactory.getLogger();
    public static final String TRACE_ID_PATTERN = "-traceId=";

    public static String getThreadInfoString(ThreadInfo threadInfo, int maxFrames) {
        StringBuilder sb = new StringBuilder();
        String threadName = threadInfo.getThreadName();
        sb.append(new Date());
        sb.append('\n');
        sb.append("\"" + ThreadUtils.getOriginThreadName(threadName) + "\" Id=" + threadInfo.getThreadId() + " " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            sb.append(" on " + threadInfo.getLockName());
        }
        if (threadInfo.getLockOwnerName() != null) {
            sb.append(" owned by \"" + threadInfo.getLockOwnerName() + "\" Id=" + threadInfo.getLockOwnerId());
        }
        if (threadInfo.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (threadInfo.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = threadInfo.getStackTrace();
        ThreadUtils.getStackTrace(stackTrace, maxFrames, threadInfo, sb);
        LockInfo[] locks = threadInfo.getLockedSynchronizers();
        if (locks.length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo li : locks) {
                sb.append("\t- " + li);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }

    public static long getCpuTime(long id) {
        try {
            return tmx.getThreadCpuTime(id);
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "failed to get thread cpu time", e);
            return -1L;
        }
    }

    public static long getMemory(long id) {
        try {
            long memory;
            ObjectName objectName = tmx.getObjectName();
            Object result = server.invoke(objectName, "getThreadAllocatedBytes", new Object[]{id}, new String[]{Long.TYPE.getName()});
            if (result != null && result instanceof Long && (memory = Long.valueOf(result.toString()).longValue()) > -1L) {
                return memory;
            }
        }
        catch (Throwable e) {
            LOGGER.warningFullQueue("\u7ebf\u7a0b\u5360\u7528\u5185\u5b58\u83b7\u53d6\u5931\u8d25");
        }
        return 0L;
    }

    private static void getStackTrace(StackTraceElement[] stackTrace, int maxFrames, ThreadInfo threadInfo, StringBuilder sb) {
        int i;
        for (i = 0; i < stackTrace.length && i < maxFrames; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            for (MonitorInfo mi : threadInfo.getLockedMonitors()) {
                if (mi.getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + mi);
                sb.append('\n');
            }
        }
        if (i < stackTrace.length) {
            sb.append("\t...");
            sb.append('\n');
        }
    }

    public static ThreadInfo getThreadInfo(Long threadId, int maxFrames) {
        return tmx.getThreadInfo(threadId, maxFrames);
    }

    public static String getOriginThreadName(String threadName) {
        if (threadName == null) {
            return null;
        }
        int preTraceIndex = threadName.indexOf(TRACE_ID_PATTERN);
        if (preTraceIndex > 0) {
            threadName = threadName.substring(0, preTraceIndex);
        }
        return threadName;
    }

    public static void resetThreadName() {
        String threadName = Thread.currentThread().getName();
        if (threadName == null) {
            return;
        }
        int preTraceIndex = threadName.indexOf(TRACE_ID_PATTERN);
        if (preTraceIndex > 0) {
            String newThreadName = threadName.substring(0, preTraceIndex);
            Thread.currentThread().setName(newThreadName);
        }
    }

    public static void updateThreadName(String traceId, Boolean isPrintTraceId) {
        String threadName = Thread.currentThread().getName();
        String originThreadName = ThreadUtils.getOriginThreadName(threadName);
        if (StringUtils.isBlank(originThreadName)) {
            LOGGER.severe("originThreadName is empty");
            return;
        }
        String newThreadName = isPrintTraceId == null || isPrintTraceId == false ? originThreadName : originThreadName + TRACE_ID_PATTERN + traceId;
        Thread.currentThread().setName(newThreadName);
    }
}

