/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.trace;

import com.lubanops.apm.bootstrap.agent.AgentInfo;
import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.otel.ConstantsTrace;
import com.lubanops.apm.bootstrap.otel.OtelSpanKind;
import com.lubanops.apm.bootstrap.profiler.ProfilerService;
import com.lubanops.apm.bootstrap.sample.SamplingRate;
import com.lubanops.apm.bootstrap.sample.SamplingStrategy;
import com.lubanops.apm.bootstrap.trace.ErrorType;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.ISpanEventPool;
import com.lubanops.apm.bootstrap.trace.OtelTraceReportService;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceReportService;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.AntPathMatcher;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import io.opentelemetry.api.trace.Span;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TraceCollector {
    private static final int MAX_SPAN_EVENT_COUNT = 200;
    public static final ThreadLocal<String> G_TRACE_ID_THREAD_LOCAL = new ThreadLocal();
    public static final ThreadLocal<String> USER_FLAG_THREAD_LOCAL = new ThreadLocal();
    public static final ThreadLocal<String> POLICY_ID_THREAD_LOCAL = new ThreadLocal();
    public static final ThreadLocal<SpanEvent.DiscardInfo> DISCARD_INFO = new ThreadLocal();
    public static final ThreadLocal<Boolean> EXCEPTION_LOCAL = new ThreadLocal();
    public static final ThreadLocal<String> EXCEPTION_TYPE_LOCAL = new ThreadLocal();
    private static ThreadLocal<SpanEvent> threadLocal = new ThreadLocal();
    private static final Logger LOGGER = LogFactory.getLogger();
    private static AntPathMatcher matcher = new AntPathMatcher();
    private static TraceReportService traceReportService;
    private static ISpanEventPool spanEventPool;
    private static OtelTraceReportService otelTraceReportService;

    public static void setSpanEventPool(ISpanEventPool spanEventPool) {
        TraceCollector.spanEventPool = spanEventPool;
    }

    public static SpanEvent onStart(StartTraceRequest startTraceRequest) {
        TraceCollector.filterSpanId(startTraceRequest);
        ProfilerService.getInstance().addThread();
        if (startTraceRequest.getSampleFilter() == null || TraceCollector.hasTraceId(startTraceRequest) || TraceCollector.isSample(startTraceRequest)) {
            long startTime = System.currentTimeMillis();
            long nanoTime = System.nanoTime();
            SpanEvent spanEvent = spanEventPool.get(startTraceRequest.getTraceId(), startTraceRequest.getSpanId(), startTraceRequest.getDomainId());
            TraceCollector.setSamplingPolicy(spanEvent, startTraceRequest);
            spanEvent.setStartTime(startTime);
            spanEvent.setType(startTraceRequest.getKind());
            spanEvent.setThreadId(Thread.currentThread().getId());
            spanEvent.setClassName(startTraceRequest.getTraceClass());
            spanEvent.setMethod(startTraceRequest.getMethod());
            spanEvent.setSource(startTraceRequest.getSource());
            spanEvent.setRealSource(startTraceRequest.getRealSource());
            spanEvent.setStartNanoTime(nanoTime);
            spanEvent.setSourceEventId(startTraceRequest.getSourceEventId());
            spanEvent.setGlobalTraceId(TraceCollector.setGtraceId(startTraceRequest, spanEvent));
            String otelSpanName = startTraceRequest.getSource();
            Span otelSpan = null;
            if (startTraceRequest.getHttpMethod() != null) {
                otelSpanName = startTraceRequest.getHttpMethod() + " " + startTraceRequest.getSource();
                otelSpan = otelTraceReportService.creatSpan(otelSpanName, OtelSpanKind.SERVER.name(), startTraceRequest.getOtelTraceParent());
                otelTraceReportService.setAttribute(otelSpan, "http.method", startTraceRequest.getHttpMethod());
                otelTraceReportService.setAttribute(otelSpan, "http.target", startTraceRequest.getRealSource());
                spanEvent.addTag("httpMethod", startTraceRequest.getHttpMethod());
            } else {
                otelSpan = startTraceRequest.getOtelTraceId() != null && startTraceRequest.getOtelSpanId() != null ? otelTraceReportService.creatSpan(otelSpanName, OtelSpanKind.INTERNAL.name(), startTraceRequest.getOtelTraceId(), startTraceRequest.getOtelSpanId()) : otelTraceReportService.creatSpan(otelSpanName, OtelSpanKind.SERVER.name(), startTraceRequest.getOtelTraceParent());
            }
            otelTraceReportService.setAttribute(otelSpan, ConstantsTrace.AttributeNetSockHostAddr.toString(), IdentityConfigManager.getMainIp());
            spanEvent.setOtelSpan(otelSpan);
            List<String> txName = TransactionCollector.getTxName();
            if (txName != null && txName.size() > 0) {
                spanEvent.addTag("transactionNames", txName.toString());
            }
            spanEvent.addTag("threadId", String.valueOf(ProfilerService.getInstance().getThreadID()));
            threadLocal.set(spanEvent);
            if (spanEvent.hasSamplingPolicy()) {
                POLICY_ID_THREAD_LOCAL.set(spanEvent.getPolicyId());
            }
            return spanEvent;
        }
        TraceCollector.setGtraceId(startTraceRequest, null);
        return null;
    }

    private static boolean isSample(StartTraceRequest startTraceRequest) {
        return StringUtils.isBlank(startTraceRequest.getgTraceId()) && startTraceRequest.getSampleFilter().sample(startTraceRequest.getSource(), startTraceRequest.getHttpMethod());
    }

    private static void setSamplingPolicy(SpanEvent spanEvent, StartTraceRequest startTraceRequest) {
        if (!StringUtils.isBlank(startTraceRequest.getPolicyId())) {
            spanEvent.setSamplingPolicy(startTraceRequest.getPolicyId());
        } else if (ConfigManager.getSamplingStrategy() == SamplingStrategy.TAIL_BASED) {
            if (startTraceRequest.getRealSource() == null) {
                spanEvent.setSamplingPolicy(String.valueOf(ConfigManager.getDefaultPolicyId()));
                return;
            }
            if (!ConfigManager.getSamplingPolicyMap().isEmpty()) {
                for (Map.Entry<Integer, SamplingRate> policy : ConfigManager.getSamplingPolicyMap().entrySet()) {
                    if (!matcher.matchStart(policy.getValue().getUrlFilter(), startTraceRequest.getRealSource())) continue;
                    spanEvent.setSamplingPolicy(String.valueOf(policy.getKey()));
                    return;
                }
            }
            spanEvent.setSamplingPolicy(String.valueOf(ConfigManager.getDefaultPolicyId()));
        }
    }

    public static void filterSpanId(StartTraceRequest startTraceRequest) {
        String spanId = startTraceRequest.getSpanId();
        if (spanId != null && spanId.length() > 100) {
            startTraceRequest.setTraceId(null);
            startTraceRequest.setSpanId(null);
        }
    }

    public static boolean hasTraceId(StartTraceRequest startTraceRequest) {
        if (AgentConfigManager.isApmOtelEnabled()) {
            String[] otelHeaders;
            int length;
            String otelTraceParent = startTraceRequest.getOtelTraceParent();
            return StringUtils.isBlank(otelTraceParent) || (length = (otelHeaders = otelTraceParent.split("-")).length) <= 1 || !"00".equals(otelHeaders[length - 1]);
        }
        return TraceCollector.isSameDomain(startTraceRequest) && !StringUtils.isBlank(startTraceRequest.getTraceId());
    }

    public static boolean isSameDomain(StartTraceRequest startTraceRequest) {
        String fromDomainId = startTraceRequest.getDomainId();
        String fromDomainType = startTraceRequest.getDomainType();
        return TraceCollector.isSameDomain(fromDomainId, fromDomainType);
    }

    public static boolean isSameDomain(String fromDomainId, String fromDomainType) {
        String toDomainId = String.valueOf(IdentityConfigManager.getDomainId());
        String toDomainType = IdentityConfigManager.getDomainType();
        if (!(StringUtils.isBlank(fromDomainType) || StringUtils.isBlank(toDomainType) || fromDomainType.equals(toDomainType))) {
            return false;
        }
        return StringUtils.isBlank(fromDomainId) || toDomainId.equals(fromDomainId);
    }

    public static String setGtraceId(StartTraceRequest startTraceRequest, SpanEvent spanEvent) {
        String globalTraceId = null;
        globalTraceId = !StringUtils.isBlank(startTraceRequest.getgTraceId()) && TraceCollector.isSameDomain(startTraceRequest) ? startTraceRequest.getgTraceId() : (spanEvent == null ? AgentInfo.generateVirtualTraceId() : spanEvent.getTraceId());
        G_TRACE_ID_THREAD_LOCAL.set(globalTraceId);
        return globalTraceId;
    }

    public static SpanEvent onStart(String className, String method, String kind) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long nanoTime = System.nanoTime();
            if (spanEvent.getChildSpanEventCount() < 200) {
                long startTime = System.currentTimeMillis();
                SpanEvent newSpanEvent = spanEventPool.get(spanEvent);
                if (newSpanEvent.getEventId().length() > 200) {
                    LOGGER.log(Level.SEVERE, "spanEventId is too long" + APIService.getJsonApi().toJSONString(spanEvent));
                    threadLocal.set(null);
                    return null;
                }
                String otelSpanName = className.replace("/", ".") + "." + method;
                newSpanEvent.setOtelSpan(otelTraceReportService.creatSpan(otelSpanName, "INTERNAL", spanEvent.getOtelSpan()));
                newSpanEvent.setStartTime(startTime);
                newSpanEvent.setStartNanoTime(nanoTime);
                newSpanEvent.setClassName(className);
                newSpanEvent.setMethod(method);
                newSpanEvent.setType(kind);
                if (spanEvent.hasSamplingPolicy()) {
                    newSpanEvent.setSamplingPolicy(spanEvent.getPolicyId());
                    POLICY_ID_THREAD_LOCAL.set(spanEvent.getPolicyId());
                }
                threadLocal.set(newSpanEvent);
                return newSpanEvent;
            }
            if (spanEvent.getDisableDeep() == 0) {
                Map<String, SpanEvent.DiscardInfo> map = spanEvent.getDiscardMap();
                SpanEvent.DiscardInfo discardInfo = map.get(kind);
                if (discardInfo == null) {
                    discardInfo = new SpanEvent.DiscardInfo();
                    map.put(kind, discardInfo);
                }
                discardInfo.setType(kind);
                spanEvent.setDiscardSpanEventStartTime(nanoTime);
                DISCARD_INFO.set(discardInfo);
            }
            spanEvent.addDisableDeep();
            return null;
        }
        return spanEvent;
    }

    public static SpanEvent onStart(String className, String method, String kind, String otelSpanName, String otelSpanKind) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long nanoTime = System.nanoTime();
            if (spanEvent.getChildSpanEventCount() < 200) {
                long startTime = System.currentTimeMillis();
                SpanEvent newSpanEvent = spanEventPool.get(spanEvent);
                if (newSpanEvent.getEventId().length() > 200) {
                    LOGGER.log(Level.SEVERE, "spanEventId is too long" + APIService.getJsonApi().toJSONString(spanEvent));
                    threadLocal.set(null);
                    return null;
                }
                newSpanEvent.setOtelSpan(otelTraceReportService.creatSpan(otelSpanName, otelSpanKind, spanEvent.getOtelSpan()));
                newSpanEvent.setStartTime(startTime);
                newSpanEvent.setStartNanoTime(nanoTime);
                newSpanEvent.setClassName(className);
                newSpanEvent.setMethod(method);
                newSpanEvent.setType(kind);
                if (spanEvent.hasSamplingPolicy()) {
                    newSpanEvent.setSamplingPolicy(spanEvent.getPolicyId());
                    POLICY_ID_THREAD_LOCAL.set(spanEvent.getPolicyId());
                }
                threadLocal.set(newSpanEvent);
                return newSpanEvent;
            }
            if (spanEvent.getDisableDeep() == 0) {
                Map<String, SpanEvent.DiscardInfo> map = spanEvent.getDiscardMap();
                SpanEvent.DiscardInfo discardInfo = map.get(kind);
                if (discardInfo == null) {
                    discardInfo = new SpanEvent.DiscardInfo();
                    map.put(kind, discardInfo);
                }
                discardInfo.setType(kind);
                spanEvent.setDiscardSpanEventStartTime(nanoTime);
                DISCARD_INFO.set(discardInfo);
            }
            spanEvent.addDisableDeep();
            return null;
        }
        return spanEvent;
    }

    public static SpanEvent onStart(String className, String method, String kind, String otelSpanName, OtelSpanKind otelSpanKind) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long nanoTime = System.nanoTime();
            if (spanEvent.getChildSpanEventCount() < 200) {
                long startTime = System.currentTimeMillis();
                SpanEvent newSpanEvent = spanEventPool.get(spanEvent);
                if (newSpanEvent.getEventId().length() > 200) {
                    LOGGER.log(Level.SEVERE, "spanEventId is too long" + APIService.getJsonApi().toJSONString(spanEvent));
                    threadLocal.set(null);
                    return null;
                }
                newSpanEvent.setOtelSpan(otelTraceReportService.creatSpan(otelSpanName, otelSpanKind.name(), spanEvent.getOtelSpan()));
                newSpanEvent.setStartTime(startTime);
                newSpanEvent.setStartNanoTime(nanoTime);
                newSpanEvent.setClassName(className);
                newSpanEvent.setMethod(method);
                newSpanEvent.setType(kind);
                newSpanEvent.addTag("threadId", String.valueOf(ProfilerService.getInstance().getThreadID()));
                if (spanEvent.hasSamplingPolicy()) {
                    newSpanEvent.setSamplingPolicy(spanEvent.getPolicyId());
                    POLICY_ID_THREAD_LOCAL.set(spanEvent.getPolicyId());
                }
                threadLocal.set(newSpanEvent);
                return newSpanEvent;
            }
            if (spanEvent.getDisableDeep() == 0) {
                Map<String, SpanEvent.DiscardInfo> map = spanEvent.getDiscardMap();
                SpanEvent.DiscardInfo discardInfo = map.get(kind);
                if (discardInfo == null) {
                    discardInfo = new SpanEvent.DiscardInfo();
                    map.put(kind, discardInfo);
                }
                discardInfo.setType(kind);
                spanEvent.setDiscardSpanEventStartTime(nanoTime);
                DISCARD_INFO.set(discardInfo);
            }
            spanEvent.addDisableDeep();
            return null;
        }
        return spanEvent;
    }

    public static SpanEvent onError(Throwable e) {
        return TraceCollector.onError(threadLocal.get(), e);
    }

    public static SpanEvent onError(SpanEvent spanEvent, Throwable e) {
        if (spanEvent != null && e != null) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            spanEvent.addTag("exceptionType", e.getClass().getName());
            spanEvent.addTag("exceptionMsg", e.getMessage(), 10000);
            spanEvent.setSpanError(true);
            spanEvent.setErrorReasons(ErrorType.EXCEPTION_ERR.name());
            TraceCollector.addOtelAttribute("exceptionType", e.getClass().getName());
            TraceCollector.addOtelAttribute("exceptionMsg", e.getMessage());
        }
        return spanEvent;
    }

    public static SpanEvent onFinally(boolean send) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long endTime = System.nanoTime();
            if (spanEvent.getDisableDeep() == 0) {
                if (spanEvent.getParent() == null) {
                    return null;
                }
                long timeUsed = endTime - spanEvent.getStartNanoTime();
                spanEvent.setTimeUsed(timeUsed);
                threadLocal.set(spanEvent.getParent());
                spanEvent.setDiscardInfo();
                if (send) {
                    TraceCollector.sendSpanEvent(spanEvent);
                }
            } else {
                TraceCollector.saveDiscardInfo(spanEvent, endTime);
                return null;
            }
        }
        return spanEvent;
    }

    private static void saveDiscardInfo(SpanEvent spanEvent, long endTime) {
        SpanEvent.DiscardInfo discardInfo;
        spanEvent.subDisableDeep();
        if (spanEvent.getDisableDeep() == 0 && (discardInfo = DISCARD_INFO.get()) != null) {
            DISCARD_INFO.set(null);
            if (spanEvent.getDiscardSpanEventStartTime() > 0L) {
                long timeUsed = endTime - spanEvent.getDiscardSpanEventStartTime();
                spanEvent.setDiscardSpanEventStartTime(0L);
                discardInfo.setCount(discardInfo.getCount() + 1);
                discardInfo.setTotalTime(discardInfo.getTotalTime() + timeUsed);
            }
        }
    }

    public static SpanEvent onFinally() {
        return TraceCollector.onFinally(true);
    }

    public static SpanEvent onFinally(int code, boolean isError) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long endTime = System.nanoTime();
            long timeUsed = endTime - spanEvent.getStartNanoTime();
            spanEvent.setTimeUsed(timeUsed);
            try {
                Span otelSpan = spanEvent.getOtelSpan();
                otelTraceReportService.setAttribute(otelSpan, "http.status_code", code);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            spanEvent.setCode(code);
            if (isError) {
                spanEvent.setSpanError(isError);
                spanEvent.setErrorReasons(ErrorType.CODE_ERR.name());
            }
            threadLocal.set(null);
            spanEvent.setDiscardInfo();
            spanEvent.setThreadId(null);
            TraceCollector.sendSpanEvent(spanEvent);
        }
        ProfilerService.getInstance().removeThread();
        G_TRACE_ID_THREAD_LOCAL.set(null);
        USER_FLAG_THREAD_LOCAL.set(null);
        POLICY_ID_THREAD_LOCAL.set(null);
        return spanEvent;
    }

    public static SpanEvent onRootFinallyNoSend() {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null) {
            long endTime = System.nanoTime();
            long timeUsed = endTime - spanEvent.getStartNanoTime();
            spanEvent.setTimeUsed(timeUsed);
            threadLocal.set(null);
            spanEvent.setDiscardInfo();
        }
        G_TRACE_ID_THREAD_LOCAL.set(null);
        USER_FLAG_THREAD_LOCAL.set(null);
        POLICY_ID_THREAD_LOCAL.set(null);
        return spanEvent;
    }

    public static SpanEvent onFinally(int code) {
        return TraceCollector.onFinally(code, false);
    }

    public static void sendSpanEvent(SpanEvent spanEvent) {
        if (spanEvent == null) {
            LOGGER.log(Level.SEVERE, "[Trace Collector]push span event error,NOP event.");
            return;
        }
        if (ConfigManager.isOtelCollectorEnable()) {
            otelTraceReportService.sendSpan(spanEvent.getOtelSpan(), spanEvent.getHasError());
        } else {
            traceReportService.offerEvent(spanEvent);
        }
    }

    public static void onFinallySpanEvent(SpanEvent spanEvent) {
        long endTime = System.nanoTime();
        long timeUsed = endTime - spanEvent.getStartNanoTime();
        spanEvent.setTimeUsed(timeUsed);
        if (ConfigManager.isOtelCollectorEnable()) {
            otelTraceReportService.sendSpan(spanEvent.getOtelSpan(), spanEvent.getHasError());
        } else {
            traceReportService.offerEvent(spanEvent);
        }
    }

    public static SpanEvent onFinallySpanEvent(int code, boolean isError, SpanEvent spanEvent) {
        if (spanEvent != null) {
            long endTime = System.nanoTime();
            long timeUsed = endTime - spanEvent.getStartNanoTime();
            spanEvent.setTimeUsed(timeUsed);
            spanEvent.setCode(code);
            if (isError) {
                spanEvent.setSpanError(isError);
                spanEvent.setErrorReasons(ErrorType.CODE_ERR.name());
            }
            spanEvent.setDiscardInfo();
            spanEvent.setThreadId(null);
            TraceCollector.sendSpanEvent(spanEvent);
        }
        return spanEvent;
    }

    public static void clear() {
        threadLocal.set(null);
        G_TRACE_ID_THREAD_LOCAL.set(null);
        USER_FLAG_THREAD_LOCAL.set(null);
        POLICY_ID_THREAD_LOCAL.set(null);
    }

    public static SpanEvent getSpanEvent() {
        SpanEvent spanevent = threadLocal.get();
        if (spanevent == null || spanevent.getDisableDeep() > 0) {
            return null;
        }
        return spanevent;
    }

    public static void setSpanEvent(SpanEvent spanEvent) {
        threadLocal.set(spanEvent);
    }

    public static String getTraceId() {
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        return spanEvent == null ? null : spanEvent.getTraceId();
    }

    public static String getVirtualTraceId() {
        return G_TRACE_ID_THREAD_LOCAL.get();
    }

    public static String getUserFlag() {
        return USER_FLAG_THREAD_LOCAL.get();
    }

    public static String getPolicyId() {
        return POLICY_ID_THREAD_LOCAL.get();
    }

    public static void addTag(String key, String value) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null && spanEvent.getDisableDeep() == 0) {
            spanEvent.addTag(key, value);
        }
    }

    public static void addTag(String key, String value, int limit) {
        SpanEvent spanEvent = threadLocal.get();
        if (spanEvent != null && spanEvent.getDisableDeep() == 0) {
            spanEvent.addTag(key, value, limit);
        }
    }

    public static Map<String, Object> getTraceMapByCseContext(String cseContext) {
        if (cseContext != null) {
            try {
                HashMap map = APIService.getJsonApi().parseObject(cseContext, HashMap.class);
                return map;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getCseMapValue(Map map, String key) {
        if (map == null) {
            return null;
        }
        Object value = map.get(key);
        return value == null ? null : String.valueOf(value);
    }

    public static void setReportService(TraceReportService traceReportService) {
        TraceCollector.traceReportService = traceReportService;
    }

    public static void setOtelTracerService(OtelTraceReportService otelTraceReportService) {
        TraceCollector.otelTraceReportService = otelTraceReportService;
    }

    public static Boolean hasException() {
        Boolean hasException = EXCEPTION_LOCAL.get();
        if (hasException == null) {
            return false;
        }
        EXCEPTION_LOCAL.set(null);
        return hasException;
    }

    public static void setException(Boolean hasException) {
        EXCEPTION_LOCAL.set(hasException);
    }

    public static void injectHeader(Map<String, String> headers, Span span) {
        otelTraceReportService.injectParentSpan(headers, span);
    }

    public static void addOtelAttribute(Span span, String key, Object obj) {
        otelTraceReportService.setAttribute(span, key, obj);
    }

    public static void addOtelAttribute(String key, Object obj) {
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        if (spanEvent == null) {
            return;
        }
        otelTraceReportService.setAttribute(spanEvent.getOtelSpan(), key, obj);
    }

    public static void addOtelAttribute(String key, String value, int limit) {
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        if (spanEvent == null || key == null || value == null) {
            return;
        }
        value = StringUtils.stringTruncat(value, limit, "...");
        otelTraceReportService.setAttribute(spanEvent.getOtelSpan(), key, value);
    }

    public static String getOtelSpanId(Span span) {
        return otelTraceReportService.getSpanId(span);
    }

    public static String getOtelTraceId(Span span) {
        return otelTraceReportService.getTraceId(span);
    }

    public static String getW3CHeader(Span span) {
        if (span == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        otelTraceReportService.injectParentSpan(headers, span);
        return headers.get(Headers.OTEL_HEADER.getValue());
    }

    public static String getExceptionType() {
        String exceptionType = EXCEPTION_TYPE_LOCAL.get();
        EXCEPTION_TYPE_LOCAL.set(null);
        return exceptionType;
    }

    public static void setExceptionType(String exceptionType) {
        EXCEPTION_TYPE_LOCAL.set(exceptionType);
    }
}

