/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.common;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.DefaultSectionStats;
import com.lubanops.apm.bootstrap.utils.ExceptionUtil;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class DefaultSqlSectionStats
extends DefaultSectionStats {
    private final AtomicLong updatedRowCount = new AtomicLong(0L);
    private final AtomicLong readRowCount = new AtomicLong(0L);
    private final AtomicReference<String> lastSlowSql = new AtomicReference();
    private final AtomicReference<String> lastErrorSql = new AtomicReference();
    private final AtomicReference<String> lastError = new AtomicReference();
    private final AtomicReference<String> slowTraceId = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private volatile long updatedRowCountOld;
    private volatile long readRowCountOld;

    public void onThrowable(String sql, Throwable t) {
        super.onThrowable(t);
        if (this.lastError.get() == null) {
            String stackTrace = ExceptionUtil.getThrowableStackTrace(t, false);
            this.lastError.set(stackTrace);
        }
        if (this.lastErrorSql.get() == null) {
            this.lastErrorSql.set(sql);
        }
    }

    public boolean onFinally(String sql, long timeInNanos, int updatedRowCount, int readRowCount) {
        this.updatedRowCount.addAndGet(updatedRowCount);
        this.readRowCount.addAndGet(readRowCount);
        boolean flag = super.onFinally(timeInNanos);
        if (flag && this.lastSlowSql.get() == null) {
            this.lastSlowSql.set(sql);
        }
        return flag;
    }

    public void setSlowTraceId(String slowTraceId) {
        if (slowTraceId != null) {
            this.slowTraceId.set(slowTraceId);
        }
    }

    public void setErrorTraceId(String errorTraceId) {
        if (errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }

    @Override
    public MonitorDataRow getStatus() {
        MonitorDataRow row = super.getStatus();
        row.put("updatedRowCount", this.updatedRowCount.get());
        row.put("readRowCount", this.readRowCount.get());
        row.put("lastSlowSql", this.lastSlowSql.get());
        row.put("lastErrorSql", this.lastErrorSql.get());
        row.put("lastError", this.lastError.get());
        row.put("slowTraceId", this.slowTraceId.get());
        row.put("errorTraceId", this.errorTraceId.get());
        return row;
    }

    @Override
    public MonitorDataRow harvest(int[] newRanges) {
        MonitorDataRow row = super.harvest(newRanges);
        if (row != null) {
            long updatedRowCountNew = this.updatedRowCount.get();
            row.put("updatedRowCount", updatedRowCountNew - this.updatedRowCountOld);
            long readRowCountNew = this.readRowCount.get();
            row.put("readRowCount", readRowCountNew - this.readRowCountOld);
            row.put("lastSlowSql", this.lastSlowSql.getAndSet(null));
            row.put("lastErrorSql", this.lastErrorSql.getAndSet(null));
            row.put("lastError", this.lastError.getAndSet(null));
            row.put("slowTraceId", this.slowTraceId.getAndSet(null));
            row.put("errorTraceId", this.errorTraceId.getAndSet(null));
            this.updatedRowCountOld = updatedRowCountNew;
            this.readRowCountOld = readRowCountNew;
        }
        return row;
    }
}

