/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.log;

import com.lubanops.apm.bootstrap.log.LogEvent;
import com.lubanops.apm.bootstrap.log.LogFileWriter;
import com.lubanops.apm.bootstrap.log.LogPathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.concurrent.ArrayBlockingQueue;

public class LoggerThread
extends Thread {
    public static final int FILE_COUNT = 3;
    public static final int FILE_SIZE = 0x1400000;
    protected static final ArrayBlockingQueue<LogEvent> logQueue = new ArrayBlockingQueue(50);
    private LogFileWriter fileWriter;

    public LoggerThread() {
        super("APMLoggerThread");
        this.setDaemon(true);
        this.rollOver();
    }

    @Override
    public void run() {
        try {
            while (true) {
                LogEvent logEvent = logQueue.take();
                if (this.fileWriter.getCount() > 0x1400000) {
                    this.rollOver();
                }
                this.fileWriter.write(logEvent.getDate() + "[" + logEvent.getLevel().getName() + "]" + logEvent.getMsg());
                this.fileWriter.write(System.getProperty("line.separator"));
                Throwable e = logEvent.getE();
                if (e != null) {
                    StackTraceElement[] stackTrace;
                    PrintWriter pw = new PrintWriter(this.fileWriter);
                    e.printStackTrace(pw);
                    if (e.getMessage() != null) {
                        this.fileWriter.addCount(e.getMessage().length());
                    }
                    for (StackTraceElement element : stackTrace = e.getStackTrace()) {
                        this.fileWriter.addCount(element.toString().length());
                    }
                }
                this.fileWriter.flush();
            }
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private boolean rollOver() {
        boolean result = false;
        try {
            File oldFile;
            File maxCountFile;
            String logFilePath = LogPathUtils.getLogPath() + "logs" + File.separator;
            File fileFolder = new File(logFilePath);
            if (!fileFolder.exists()) {
                result = fileFolder.mkdirs();
            }
            if ((maxCountFile = new File(logFilePath + "apm." + 3 + ".log")).exists()) {
                result = maxCountFile.delete();
            }
            for (int i = 2; i > 0; --i) {
                File oldFile2 = new File(logFilePath + "apm." + i + ".log");
                File newFile = new File(logFilePath + "apm." + (i + 1) + ".log");
                result = oldFile2.renameTo(newFile);
            }
            if (this.fileWriter != null) {
                this.fileWriter.close();
            }
            if ((oldFile = new File(logFilePath + "apm.log")).exists()) {
                result = oldFile.renameTo(new File(logFilePath + "apm.1.log"));
            }
            this.setFile(logFilePath + "apm.log");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    private void setFile(String fileName) throws FileNotFoundException {
        FileOutputStream ostream;
        block2: {
            ostream = null;
            try {
                ostream = new FileOutputStream(fileName, false);
            }
            catch (FileNotFoundException ex) {
                File parentDir;
                String parentName = new File(fileName).getParent();
                if (parentName == null || (parentDir = new File(parentName)).exists() || !parentDir.mkdirs()) break block2;
                ostream = new FileOutputStream(fileName, false);
            }
        }
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)ostream, Charset.forName("UTF-8"));
        this.fileWriter = new LogFileWriter(osw);
    }
}

