/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.config;

import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.Stats;
import com.lubanops.apm.bootstrap.config.SysConfigKey;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.sample.SamplingRate;
import com.lubanops.apm.bootstrap.sample.SamplingStrategy;
import com.lubanops.apm.bootstrap.sample.TailSamplingPolicy;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ConfigManager {
    private static final Logger LOGGER = LogFactory.getLogger();
    public static final int DEFAULT_MAX_ROW = 500;
    public static final int DEFAULT_TX_MAX_ROW = 2000;
    public static final int TX_MAX_ROW_H = 20000;
    public static final int MAX_ROW_H = 2000;
    public static final int MAX_ROW_L = 10;
    public static final int DEFAULT_SLOW_SQL_THRESHOLD = 800;
    public static final int SLOW_SQL_THRESHOLD_H = 20000;
    public static final int SLOW_SQL_THRESHOLD_L = 100;
    public static final int DEFAULT_SLOW_REQUEST_THRESHOLD = 800;
    public static final int SLOW_REQUEST_THRESHOLD_H = 20000;
    public static final int SLOW_REQUEST_THRESHOLD_L = 100;
    public static final boolean DEFAULT_SECURE_CHANNEL = true;
    public static final boolean DEFAULT_PARSE_REDIS_BODY = false;
    public static final int DEFAULT_PARSE_REDIS_LENGTH = 100;
    private static int slowSqlThreshold = 800;
    private static int slowRequestThreshold = 800;
    private static Stats slowRequestTraceCountStats = Stats.SLOW_DEFAULT;
    private static Stats errorRequestTraceCounStats = Stats.ERROR_DEFAULT;
    private static Stats requestTranceCountStats = Stats.NORMAL_DEFAULT;
    private static boolean hideExceptionMessage = false;
    private static boolean stopAgent = false;
    private static boolean isValidated = true;
    private static int maxExceptionLength = 4096;
    private static int maxRow = 500;
    private static boolean parseRedisBody = false;
    private static int parseRedisLength = 100;
    private static boolean secureChannel = true;
    private static int stackThreshold = 0;
    private static Map<Integer, SamplingRate> samplingPolicyMap = new LinkedHashMap<Integer, SamplingRate>();
    private static SamplingStrategy samplingStrategy = SamplingStrategy.INTELLIGENT;
    private static int globalSamplingRate = 100;
    private static boolean otelCollectorEnable = false;
    private static int defaultPolicyId = 0;

    public static boolean isOtelCollectorEnable() {
        return otelCollectorEnable;
    }

    public static void setOtelCollectorEnable(boolean otelCollectorEnable) {
        ConfigManager.otelCollectorEnable = otelCollectorEnable;
    }

    public static void setGlobalSamplingRate(int globalSamplingRate) {
        ConfigManager.globalSamplingRate = globalSamplingRate;
    }

    public static int getGlobalSamplingRate() {
        return globalSamplingRate;
    }

    public static void setSamplingStrategy(SamplingStrategy samplingStrategy) {
        ConfigManager.samplingStrategy = samplingStrategy;
    }

    public static SamplingStrategy getSamplingStrategy() {
        return samplingStrategy;
    }

    public static void setDefaultPolicyId(int defaultPolicyId) {
        ConfigManager.defaultPolicyId = defaultPolicyId;
    }

    public static int getDefaultPolicyId() {
        return defaultPolicyId;
    }

    public static void setSamplingPolicyMap(List<TailSamplingPolicy> policyCollection) {
        LinkedHashMap<Integer, SamplingRate> newSamplingPolicyMap = new LinkedHashMap<Integer, SamplingRate>();
        policyCollection.forEach(policy -> {
            if (policy.urlFilter.equals("/**")) {
                defaultPolicyId = policy.policyId;
                return;
            }
            if (policy.urlFilter == null) {
                return;
            }
            newSamplingPolicyMap.put(policy.policyId, new SamplingRate(policy.successSamplingRate, policy.urlFilter));
        });
        samplingPolicyMap = newSamplingPolicyMap;
    }

    public static Map<Integer, SamplingRate> getSamplingPolicyMap() {
        return samplingPolicyMap;
    }

    public static boolean setSystemProperties(Map<String, String> propMap) {
        ConfigManager.setAgentConfig(propMap);
        ConfigManager.setStats(propMap);
        String s = propMap.get(SysConfigKey.getHideExceptionMessage());
        if ("1".equals(s)) {
            ConfigManager.setHideExceptionMessage(true);
        } else {
            ConfigManager.setHideExceptionMessage(false);
        }
        s = propMap.get(SysConfigKey.getMaxExceptionLength());
        if (s == null) {
            ConfigManager.setMaxExceptionLength(4096);
        } else {
            ConfigManager.setMaxExceptionLength(Integer.parseInt(s));
        }
        s = propMap.get(SysConfigKey.getCollectorParseRedisBody());
        if (!StringUtils.isBlank(s)) {
            ConfigManager.setParseRedisBody(Boolean.parseBoolean(s));
        } else {
            ConfigManager.setParseRedisBody(false);
        }
        s = propMap.get(SysConfigKey.getCollectorParseRedisLength());
        if (!StringUtils.isBlank(s)) {
            ConfigManager.setParseRedisLength(Integer.parseInt(s));
        } else {
            ConfigManager.setParseRedisLength(100);
        }
        s = propMap.get(SysConfigKey.getUseSecureChannel());
        boolean oldSecureChannel = ConfigManager.isSecureChannel();
        if (!StringUtils.isBlank(s)) {
            ConfigManager.setSecureChannel(Boolean.parseBoolean(s));
        } else {
            ConfigManager.setSecureChannel(true);
        }
        boolean needConnect = false;
        if (oldSecureChannel != ConfigManager.isSecureChannel()) {
            needConnect = true;
        }
        return needConnect;
    }

    private static void setStats(Map<String, String> propMap) {
        String s = propMap.get(SysConfigKey.getSlowRequestTraceCount());
        if (StringUtils.isBlank(s)) {
            ConfigManager.setSlowRequestTraceCountStats(Stats.SLOW_DEFAULT);
        } else {
            ConfigManager.setSlowRequestTraceCountStats(Stats.parseValue(s));
        }
        s = propMap.get(SysConfigKey.getErrorRequestTranceCount());
        if (StringUtils.isBlank(s)) {
            ConfigManager.setErrorRequestTraceCounStats(Stats.ERROR_DEFAULT);
        } else {
            ConfigManager.setErrorRequestTraceCounStats(Stats.parseValue(s));
        }
        s = propMap.get(SysConfigKey.getRequestTranceCount());
        if (StringUtils.isBlank(s)) {
            ConfigManager.setRequestTranceCountStats(Stats.NORMAL_DEFAULT);
        } else {
            ConfigManager.setRequestTranceCountStats(Stats.parseValue(s));
        }
    }

    private static void setAgentConfig(Map<String, String> propMap) {
        int iv;
        String s = propMap.get(SysConfigKey.getSlowSqlThreshold());
        if (StringUtils.isBlank(s)) {
            ConfigManager.setSlowSqlThreshold(800);
        } else {
            try {
                iv = Integer.parseInt(s);
                ConfigManager.setSlowSqlThreshold(iv);
            }
            catch (NumberFormatException e) {
                ConfigManager.setSlowSqlThreshold(800);
                LOGGER.log(Level.SEVERE, "setAgentConfig SlowSqlThreshold " + e.getMessage() + ",type:" + e.getClass().getName(), e);
            }
        }
        s = propMap.get(SysConfigKey.getSlowRequestThreshold());
        if (StringUtils.isBlank(s)) {
            ConfigManager.setSlowRequestThreshold(800);
        } else {
            try {
                iv = Integer.parseInt(s);
                ConfigManager.setSlowRequestThreshold(iv);
            }
            catch (NumberFormatException e) {
                ConfigManager.setSlowRequestThreshold(800);
                LOGGER.log(Level.SEVERE, "setAgentConfig SlowRequestThreshold " + e.getMessage() + ",type:" + e.getClass().getName(), e);
            }
        }
        s = propMap.get(SysConfigKey.getStopAgent());
        if ("1".equals(s)) {
            ConfigManager.setStopAgent(true);
        } else {
            ConfigManager.setStopAgent(false);
        }
        s = propMap.get(SysConfigKey.getMaxRows());
        if (StringUtils.isBlank(s)) {
            ConfigManager.setMaxRow(500);
        } else {
            ConfigManager.setMaxRow(Integer.parseInt(s));
        }
        s = propMap.get(SysConfigKey.getTxMaxRows());
        if (StringUtils.isBlank(s)) {
            ConfigManager.setTxMaxRow(2000);
        } else {
            ConfigManager.setTxMaxRow(Integer.parseInt(s));
        }
    }

    public static int getMaxExceptionLength() {
        return maxExceptionLength;
    }

    public static void setMaxExceptionLength(int maxExceptionLength) {
        ConfigManager.maxExceptionLength = maxExceptionLength;
    }

    public static boolean isHideExceptionMessage() {
        return hideExceptionMessage;
    }

    public static void setHideExceptionMessage(boolean hideExceptionMessage) {
        ConfigManager.hideExceptionMessage = hideExceptionMessage;
    }

    public static boolean isSecureChannel() {
        return secureChannel;
    }

    public static void setSecureChannel(boolean secureChannel) {
        ConfigManager.secureChannel = AgentConfigManager.isSecureChannel() != null ? AgentConfigManager.isSecureChannel() : secureChannel;
    }

    public static boolean isParseRedisBody() {
        return parseRedisBody;
    }

    public static void setParseRedisBody(boolean parseRedisBody) {
        ConfigManager.parseRedisBody = parseRedisBody;
    }

    public static int getParseRedisLength() {
        return parseRedisLength;
    }

    public static void setParseRedisLength(int parseRedisLength) {
        ConfigManager.parseRedisLength = parseRedisLength;
    }

    public static int getMaxRow() {
        return maxRow;
    }

    public static void setMaxRow(int maxRow) {
        if (maxRow > 2000 || maxRow < 10) {
            maxRow = 500;
        }
        ConfigManager.maxRow = maxRow;
    }

    public static void setTxMaxRow(int txMaxRow) {
        if (txMaxRow > 20000) {
            txMaxRow = 2000;
        }
        TransactionCollector.setMaxRowCount(txMaxRow);
    }

    public static int getSlowSqlThreshold() {
        return slowSqlThreshold;
    }

    public static void setSlowSqlThreshold(int slowSqlThreshold) {
        if (slowSqlThreshold > 20000 || slowSqlThreshold < 100) {
            slowSqlThreshold = 800;
        }
        ConfigManager.slowSqlThreshold = slowSqlThreshold;
    }

    public static int getSlowRequestThreshold() {
        return slowRequestThreshold;
    }

    public static void setSlowRequestThreshold(int slowRequestThreshold) {
        if (slowRequestThreshold > 20000 || slowRequestThreshold < 100) {
            slowRequestThreshold = 800;
        }
        ConfigManager.slowRequestThreshold = slowRequestThreshold;
    }

    public static Stats getSlowRequestTraceCountStats() {
        return slowRequestTraceCountStats;
    }

    public static void setSlowRequestTraceCountStats(Stats slowRequestTraceCountStats) {
        ConfigManager.slowRequestTraceCountStats = slowRequestTraceCountStats;
    }

    public static Stats getErrorRequestTraceCounStats() {
        return errorRequestTraceCounStats;
    }

    public static void setErrorRequestTraceCounStats(Stats errorRequestTraceCounStats) {
        ConfigManager.errorRequestTraceCounStats = errorRequestTraceCounStats;
    }

    public static Stats getRequestTranceCountStats() {
        return requestTranceCountStats;
    }

    public static void setRequestTranceCountStats(Stats requestTranceCountStats) {
        ConfigManager.requestTranceCountStats = requestTranceCountStats;
    }

    public static boolean isStopAgent() {
        return stopAgent;
    }

    public static void setStopAgent(boolean stopAgent) {
        ConfigManager.stopAgent = stopAgent;
    }

    public static boolean isValidated() {
        return isValidated;
    }

    public static void setValidated(boolean isValidated) {
        ConfigManager.isValidated = isValidated;
    }

    public static int getStackThreshold() {
        return stackThreshold;
    }

    public static void setStackThreshold(Integer stackThreshold) {
        ConfigManager.stackThreshold = stackThreshold == null ? 0 : stackThreshold;
    }
}

