/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.debugger.service.message.command;

import com.lubanops.apm.integration.debugger.model.ArthasDebuggerCommand;
import com.lubanops.apm.integration.debugger.service.message.AbstractMessageProvider;
import com.lubanops.apm.integration.debugger.service.message.Requests;
import org.apache.commons.lang3.StringUtils;

public class SearchClassCommand
extends AbstractMessageProvider<SearchClassCommand> {
    @Override
    public ArthasDebuggerCommand buildArthasCommand(Requests.Arguments commandArguments) {
        Requests.SearchClassArguments args = (Requests.SearchClassArguments)commandArguments;
        return this.toCommandLine(args);
    }

    @Override
    public Class<SearchClassCommand> getType() {
        return SearchClassCommand.class;
    }

    private ArthasDebuggerCommand toCommandLine(Requests.SearchClassArguments args) {
        StringBuilder sb = new StringBuilder("sc -d");
        if (args.isField()) {
            sb.append(" -f");
        }
        if (StringUtils.isBlank((CharSequence)args.getClassPattern())) {
            return new ArthasDebuggerCommand("", "Class pattern must have a value", false);
        }
        if (args.isWildcard()) {
            sb.append(" *" + args.getClassPattern() + "*");
        } else {
            sb.append(" " + args.getClassPattern());
        }
        if (args.getLimit() != null) {
            sb.append(" -n " + args.getLimit().toString());
        }
        return new ArthasDebuggerCommand(sb.toString(), "", true);
    }
}

