/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access.inbound;

import com.lubanops.apm.integration.access.Message;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.access.inbound.EventDataBody;
import com.lubanops.apm.integration.access.inbound.EventDataHeader;
import com.lubanops.apm.integration.utils.JSON;
import java.util.Map;

public class EventDataRequest
extends MessageWrapper {
    private EventDataHeader header;
    private EventDataBody body;
    private long messageId;
    Message message;

    @Override
    public Message generatorMessage() {
        this.message.setType(this.getType());
        this.message.setMessageId(this.getMessageId());
        this.message.setHeader(this.getHeaderBytes());
        this.message.setBody(this.getBodyBytes());
        return this.message;
    }

    public EventDataRequest(Message msg) {
        this.message = msg;
    }

    public EventDataRequest() {
        this.message = new Message();
    }

    public static EventDataRequest parse(Message message) {
        if (message.getType() != 3) {
            throw new IllegalArgumentException("type not match");
        }
        try {
            EventDataRequest request = new EventDataRequest();
            EventDataHeader head = JSON.parseObject(message.getHeader(), EventDataHeader.class);
            EventDataBody body = JSON.parseObject(message.getBody(), EventDataBody.class);
            request.setMessageId(message.getMessageId());
            request.setHeader(head);
            request.setBody(body);
            return request;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to parse msg,msg type:" + message.getType(), e);
        }
    }

    public static EventDataHeader parseHeader(Message message) {
        return JSON.parseObject(message.getHeader(), EventDataHeader.class);
    }

    public EventDataHeader getHeader() {
        return this.header;
    }

    public void setHeader(EventDataHeader header) {
        this.header = header;
    }

    public EventDataBody getBody() {
        return this.body;
    }

    public void setBody(EventDataBody body) {
        this.body = body;
    }

    @Override
    public void setBodyBytes(byte[] body) {
        this.bodyBytes = body;
    }

    @Override
    public short getType() {
        return 3;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    @Override
    public byte[] getHeaderBytes() {
        return this.header.toBytes();
    }

    @Override
    public long getMessageId() {
        return this.messageId;
    }

    @Override
    public String getHeadString() {
        return JSON.toJSONString(this.header);
    }

    @Override
    public String generateBodyString() {
        Map<String, Object> tag = this.body.getTags();
        Object mysqlResult = tag.get("mysqlResult");
        if (mysqlResult != null) {
            tag.put("mysqlResult", JSON.toJSONString(mysqlResult));
        }
        return JSON.toJSONString(this.body);
    }

    @Override
    public byte[] getBodyBytes() {
        if (this.bodyBytes != null) {
            return this.bodyBytes;
        }
        Map<String, Object> tag = this.body.getTags();
        Object mysqlResult = tag.get("mysqlResult");
        if (mysqlResult != null) {
            tag.put("mysqlResult", JSON.toJSONString(mysqlResult));
        }
        if (null == this.bodyBytes) {
            this.bodyBytes = JSON.toJSONBytes(this.body);
        }
        return this.bodyBytes;
    }
}

