/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.integration.access;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class Message {
    public static final short MAGIC_NUMBER = 9527;
    private short type;
    private long messageId;
    private byte[] header;
    private byte[] body;
    private ByteBuffer msg = ByteBuffer.allocateDirect(512);

    public static Message parseBytes(byte[] bb) {
        if (bb.length > 0x100000) {
            throw new IllegalArgumentException("message length exceeds max value:1048576,actual:" + bb.length);
        }
        ByteArrayInputStream byteArrayInputStream = null;
        byteArrayInputStream = new ByteArrayInputStream(bb);
        DataInputStream dataInputStream = null;
        dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            int readLength;
            short magic = dataInputStream.readShort();
            if (magic != 9527) {
                throw new IllegalArgumentException("magic number error");
            }
            short type = dataInputStream.readShort();
            long messageId = dataInputStream.readLong();
            int headerLength = dataInputStream.readInt();
            int bodyLength = dataInputStream.readInt();
            if (headerLength < 0) {
                throw new IllegalArgumentException("header length less than 0");
            }
            if (headerLength > 0x100000) {
                throw new IllegalArgumentException("header length exceeds max value:1048576,actual:" + headerLength);
            }
            byte[] header = new byte[headerLength];
            if (headerLength > 0 && (readLength = dataInputStream.read(header, 0, headerLength)) < 0) {
                throw new IllegalArgumentException("header length less than 0");
            }
            if (bodyLength < 0) {
                throw new IllegalArgumentException("body length less than 0");
            }
            if (bodyLength > 0x100000) {
                throw new IllegalArgumentException("body length exceeds max value:1048576,actual:" + bodyLength);
            }
            Message message = Message.getMessage(bodyLength, dataInputStream, type, messageId, header);
            return message;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("IOException,message length:" + bb.length);
        }
        finally {
            Message.close(dataInputStream);
            Message.close(byteArrayInputStream);
        }
    }

    private static Message getMessage(int bodyLength, DataInputStream dataInputStream, short type, long messageId, byte[] header) throws IOException {
        int readLength;
        byte[] body = new byte[bodyLength];
        if (bodyLength > 0 && (readLength = dataInputStream.read(body, 0, bodyLength)) < 0) {
            throw new IllegalArgumentException("body length less than 0");
        }
        Message message = new Message();
        message.setType(type);
        message.setMessageId(messageId);
        message.setBody(body);
        message.setHeader(header);
        return message;
    }

    private static void close(InputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void close(OutputStream stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public ByteBuffer toBytes() {
        try {
            int size = 20 + this.header.length + this.body.length;
            ((Buffer)this.msg).clear();
            if (this.msg.capacity() < size) {
                this.msg = ByteBuffer.allocateDirect(8 + (size - size % 8));
            }
            this.msg.putShort((short)9527);
            this.msg.putShort(this.type);
            this.msg.putLong(this.messageId);
            this.msg.putInt(this.header.length);
            this.msg.putInt(this.body.length);
            if (this.header.length > 0) {
                this.msg.put(this.header, 0, this.header.length);
            }
            if (this.body.length > 0) {
                this.msg.put(this.body, 0, this.body.length);
            }
            ((Buffer)this.msg).rewind();
            return this.msg;
        }
        catch (Exception e) {
            throw new RuntimeException("failed to transform to bytes", e);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Message)) {
            return false;
        }
        Message msg = (Message)obj;
        return this.messageId == msg.messageId && this.type == msg.type && Arrays.equals(this.header, msg.header) && Arrays.equals(this.body, msg.body);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        this.type = type;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public void setMessageId(long messageId) {
        this.messageId = messageId;
    }

    public byte[] getHeader() {
        return this.header;
    }

    public void setHeader(byte[] header) {
        this.header = header;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[type:" + this.type);
        stringBuilder.append("\nmessageId:" + this.messageId);
        stringBuilder.append("\nheader:" + new String(this.header));
        stringBuilder.append("\nbody:" + new String(this.body));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

