/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rabbitmq;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class RabbitConnectionCounter {
    private static final ConcurrentHashMap<String, AtomicLong> CONNECTION_COUNTER = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AtomicLong> CHANNEL_COUNTER = new ConcurrentHashMap();

    public static void incrementConnectionCount(String connection) {
        RabbitConnectionCounter.incrementCount(CONNECTION_COUNTER, connection, 1);
    }

    public static void incrementConnectionCount(String connection, int delta) {
        RabbitConnectionCounter.incrementCount(CONNECTION_COUNTER, connection, delta);
    }

    public static void incrementChannelCount(String connection) {
        RabbitConnectionCounter.incrementCount(CHANNEL_COUNTER, connection, 1);
    }

    public static void incrementChannelCount(String connection, int delta) {
        RabbitConnectionCounter.incrementCount(CHANNEL_COUNTER, connection, delta);
    }

    public static void decrementConnectionCount(String connection) {
        RabbitConnectionCounter.decrementCount(CONNECTION_COUNTER, connection, 1);
    }

    public static void decrementConnectionCount(String connection, int delta) {
        RabbitConnectionCounter.decrementCount(CONNECTION_COUNTER, connection, delta);
    }

    public static void decrementChannelCount(String connection) {
        RabbitConnectionCounter.decrementCount(CHANNEL_COUNTER, connection, 1);
    }

    public static void decrementChannelCount(String connection, int delta) {
        RabbitConnectionCounter.decrementCount(CHANNEL_COUNTER, connection, delta);
    }

    public static long getConnectionCount(String connection) {
        return RabbitConnectionCounter.getCount(CONNECTION_COUNTER, connection);
    }

    public static long getChannelCount(String connection) {
        return RabbitConnectionCounter.getCount(CHANNEL_COUNTER, connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void incrementCount(ConcurrentHashMap<String, AtomicLong> counterMap, String connection, int delta) {
        AtomicLong counter;
        if (!counterMap.containsKey(connection) && counterMap.size() < 20) {
            ConcurrentHashMap<String, AtomicLong> concurrentHashMap = counterMap;
            synchronized (concurrentHashMap) {
                if (!counterMap.containsKey(connection)) {
                    counterMap.put(connection, new AtomicLong(0L));
                }
            }
        }
        if ((counter = counterMap.get(connection)) != null) {
            counter.addAndGet(delta);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decrementCount(ConcurrentHashMap<String, AtomicLong> counterMap, String connection, int delta) {
        AtomicLong counter;
        long count;
        if (counterMap.containsKey(connection) && (count = (counter = counterMap.get(connection)).addAndGet(-delta)) == 0L) {
            ConcurrentHashMap<String, AtomicLong> concurrentHashMap = counterMap;
            synchronized (concurrentHashMap) {
                if (counterMap.get(connection).get() <= 0L) {
                    counterMap.remove(connection);
                }
            }
        }
    }

    private static long getCount(ConcurrentHashMap<String, AtomicLong> counterMap, String connection) {
        if (counterMap.containsKey(connection)) {
            return counterMap.get(connection).get();
        }
        return 0L;
    }
}

