/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.url.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlStatsCollector;
import com.lubanops.apm.bootstrap.plugin.url.collector.WebContainerType;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.url.interceptor.UrlInterceptor;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import jakarta.servlet.DispatcherType;

public class UndertowInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            ServletRequestContext servletRequestContext = (ServletRequestContext)args[1];
            HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
            HttpServletResponseImpl response = servletRequestContext.getOriginalResponse();
            if (UrlStatsCollector.INSTANCE.isEnable()) {
                if (UndertowInterceptor.checkDispatcherType(args, request)) {
                    return null;
                }
                UrlInterceptor.before(request, response, className, methodName, WebContainerType.Undertow.toString());
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "UndertowInterceptor onStart", (Throwable)ex);
        }
        return new Object[0];
    }

    private static boolean checkDispatcherType(Object[] args, Object request) {
        if (UrlInterceptor.hasJavaxServlet(request)) {
            javax.servlet.DispatcherType dispatcherType = (javax.servlet.DispatcherType)args[3];
            if (dispatcherType == javax.servlet.DispatcherType.ASYNC && args[1] instanceof TransformAccess) {
                UrlInterceptor.saveAsyncData((TransformAccess)args[1]);
                return true;
            }
        } else {
            DispatcherType dispatcherType = (DispatcherType)args[3];
            if (dispatcherType == DispatcherType.ASYNC && args[1] instanceof TransformAccess) {
                UrlInterceptor.saveAsyncData((TransformAccess)args[1]);
                return true;
            }
        }
        return false;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            TraceCollector.onError((Throwable)e);
            UrlStatsCollector.onThrowable((Throwable)e);
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "UndertowInterceptor onError", (Throwable)ex);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (UrlStatsCollector.INSTANCE.isEnable()) {
                ServletRequestContext servletRequestContext = (ServletRequestContext)args[1];
                HttpServerExchange exchange = (HttpServerExchange)args[0];
                HttpServletRequestImpl request = servletRequestContext.getOriginalRequest();
                HttpServletResponseImpl response = servletRequestContext.getOriginalResponse();
                if (exchange.isDispatched() && args[1] instanceof TransformAccess) {
                    UrlInterceptor.clearAsyncData((TransformAccess)args[1]);
                    return;
                }
                UrlInterceptor.after(request, response, WebContainerType.Undertow.toString());
            }
        }
        catch (Exception ex) {
            LogFactory.getLogger().log(Level.SEVERE, "UndertowInterceptor onFinally", (Throwable)ex);
        }
    }
}

