/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.url.interceptor;

import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.config.AgentConfigManager;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.url.collector.RequestContext;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlAnalysisUtils;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlSampleFilter;
import com.lubanops.apm.bootstrap.plugin.url.collector.UrlStatsCollector;
import com.lubanops.apm.bootstrap.plugin.url.collector.body.TomcatBodyData;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlStatsConfig;
import com.lubanops.apm.bootstrap.profiler.ClassStackTagType;
import com.lubanops.apm.bootstrap.profiler.ProfilerService;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SampleFilter;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.StartTraceRequest;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JavaxInterceptor {
    public static void before(HttpServletRequest request, HttpServletResponse response, String className, String methodName, String type) {
        if (UrlStatsConfig.isBodyDetail()) {
            TomcatBodyData.start();
        }
        String cseContext = request.getHeader(Headers.CSE_CONTEXT.getValue());
        String domainId = request.getHeader(Headers.DOMAIN_ID.getValue());
        String domainType = request.getHeader(Headers.DOMAIN_TYPE.getValue());
        String traceId = request.getHeader(Headers.TRACE_ID.getValue());
        String spanId = request.getHeader(Headers.SPAN_ID.getValue());
        String sourceEventId = request.getHeader(Headers.SOURCE_EVENT_ID.getValue());
        String gtraceId = request.getHeader(Headers.GTRACE_ID.getValue());
        String policyId = request.getHeader(Headers.POLICY_ID.getValue());
        String userFlag = request.getHeader(Headers.USER_FLAG.getValue());
        String txName = request.getHeader(Headers.TXNANE_ID.getValue());
        String envId = request.getHeader(Headers.ENV_ID.getValue());
        String otelheader = request.getHeader(Headers.OTEL_HEADER.getValue());
        if (cseContext != null) {
            Map map = TraceCollector.getTraceMapByCseContext((String)cseContext);
            domainId = TraceCollector.getCseMapValue((Map)map, (String)Headers.DOMAIN_ID.getValue());
            domainType = TraceCollector.getCseMapValue((Map)map, (String)Headers.DOMAIN_TYPE.getValue());
            traceId = TraceCollector.getCseMapValue((Map)map, (String)Headers.TRACE_ID.getValue());
            spanId = TraceCollector.getCseMapValue((Map)map, (String)Headers.SPAN_ID.getValue());
            sourceEventId = TraceCollector.getCseMapValue((Map)map, (String)Headers.SOURCE_EVENT_ID.getValue());
            gtraceId = TraceCollector.getCseMapValue((Map)map, (String)Headers.GTRACE_ID.getValue());
            userFlag = TraceCollector.getCseMapValue((Map)map, (String)Headers.USER_FLAG.getValue());
            policyId = TraceCollector.getCseMapValue((Map)map, (String)Headers.POLICY_ID.getValue());
            txName = TraceCollector.getCseMapValue((Map)map, (String)Headers.TXNANE_ID.getValue());
            envId = TraceCollector.getCseMapValue((Map)map, (String)Headers.ENV_ID.getValue());
            otelheader = TraceCollector.getCseMapValue((Map)map, (String)Headers.OTEL_HEADER.getValue());
        }
        String method = request.getMethod();
        String realUrl = request.getRequestURI();
        String contextPath = request.getContextPath();
        String queryString = request.getQueryString();
        String pathInfo = request.getPathInfo();
        String targetUrl = UrlAnalysisUtils.getTargetUrl((String)realUrl, (String)pathInfo, (String)contextPath, (String)request.getServerName());
        if (AgentConfigManager.isTxEnable()) {
            TransactionCollector.generateTxList((String)txName, (String)targetUrl, (String)method);
        }
        if (targetUrl != null) {
            ProfilerService.getInstance().generateTxTag(targetUrl, method);
            UrlStatsCollector.onStart((String)targetUrl, (String)method, (String)envId);
            if (queryString != null) {
                realUrl = realUrl + "?" + queryString;
            }
            StartTraceRequest startTraceRequest = new StartTraceRequest(className, methodName, traceId, spanId, gtraceId);
            startTraceRequest.setKind(type);
            startTraceRequest.setSource(targetUrl);
            startTraceRequest.setRealSource(realUrl);
            startTraceRequest.setHttpMethod(method);
            startTraceRequest.setSourceEventId(sourceEventId);
            startTraceRequest.setDomainId(domainId);
            startTraceRequest.setDomainType(domainType);
            startTraceRequest.setSampleFilter((SampleFilter)new UrlSampleFilter());
            startTraceRequest.setOtelTraceParent(otelheader);
            startTraceRequest.setPolicyId(policyId);
            SpanEvent spanEvent = TraceCollector.onStart((StartTraceRequest)startTraceRequest);
            JavaxInterceptor.updateSpanEvent(spanEvent, request, envId);
        }
        JavaxInterceptor.setResponseHeader(response, envId, TraceCollector.isSameDomain((String)domainId, (String)domainType));
        TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
    }

    private static void setResponseHeader(HttpServletResponse response, String envId, boolean isSameDomain) {
        String traceId;
        String gTraceId = TraceCollector.getVirtualTraceId();
        if (!StringUtils.isBlank((String)gTraceId)) {
            response.addHeader(Headers.GTRACE_ID.getValue(), gTraceId);
        }
        if (!StringUtils.isBlank((String)(traceId = TraceCollector.getTraceId()))) {
            response.addHeader(Headers.TRACE_ID.getValue(), traceId);
        }
        long agentEnvId = IdentityConfigManager.getEnvId();
        if (isSameDomain && agentEnvId > 0L) {
            response.addHeader(Headers.ENV_ID.getValue(), String.valueOf(agentEnvId));
        }
    }

    private static void updateSpanEvent(SpanEvent spanEvent, HttpServletRequest request, String envId) {
        if (spanEvent != null) {
            String[] paramKeys;
            String[] headKeys;
            String remoteAddr = request.getRemoteAddr();
            TraceCollector.addTag((String)"remoteAddr", (String)remoteAddr);
            TraceCollector.addTag((String)Headers.ENV_ID.getValue(), (String)envId);
            for (String headKey : headKeys = UrlStatsConfig.getHeaderKeys()) {
                String value = request.getHeader(headKey);
                TraceCollector.addTag((String)headKey, (String)value);
            }
            for (String paramKey : paramKeys = UrlStatsConfig.getParameterKeys()) {
                String value = request.getParameter(paramKey);
                TraceCollector.addTag((String)paramKey, (String)value);
            }
            JavaxInterceptor.renderCookie(request);
        }
    }

    public static void after(HttpServletRequest request, HttpServletResponse response, String type, int code) {
        String envId = request.getHeader(Headers.ENV_ID.getValue());
        String domainId = request.getHeader(Headers.DOMAIN_ID.getValue());
        String domainType = request.getHeader(Headers.DOMAIN_TYPE.getValue());
        String cseContext = request.getHeader(Headers.CSE_CONTEXT.getValue());
        if (cseContext != null) {
            Map map = TraceCollector.getTraceMapByCseContext((String)cseContext);
            envId = TraceCollector.getCseMapValue((Map)map, (String)Headers.ENV_ID.getValue());
            domainId = TraceCollector.getCseMapValue((Map)map, (String)Headers.DOMAIN_ID.getValue());
            domainType = TraceCollector.getCseMapValue((Map)map, (String)Headers.DOMAIN_TYPE.getValue());
        }
        if (!TraceCollector.isSameDomain((String)domainId, (String)domainType)) {
            envId = null;
        }
        boolean hasException = TraceCollector.hasException();
        String exceptionType = TraceCollector.getExceptionType();
        boolean hasError = UrlStatsCollector.onFinally((int)code, (String)envId, (String)request.getRequestURI(), (boolean)hasException, (String)exceptionType);
        SpanEvent spanevent = TraceCollector.getSpanEvent();
        if (spanevent != null) {
            if (UrlStatsConfig.isBodyDetail()) {
                TomcatBodyData.end((String)request.getCharacterEncoding(), (String)"UTF-8", (String)request.getHeader("Content-Encoding"));
            }
            if (UrlStatsConfig.getBizCodeLength() > 0) {
                TomcatBodyData.parseBizError((String)"UTF-8", (String)request.getHeader("Content-Encoding"));
            }
        }
        TraceCollector.onFinally((int)code, (boolean)hasError);
        ProfilerService.getInstance().removeCallstackTag(ClassStackTagType.API);
    }

    private static void renderCookie(HttpServletRequest request) {
        String[] cookieKeys = UrlStatsConfig.getCookieKeys();
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (String cookieKey : cookieKeys) {
                String cookieValue = null;
                for (Cookie cookie : cookies) {
                    if (!cookie.getName().equalsIgnoreCase(cookieKey)) continue;
                    cookieValue = cookie.getValue();
                    break;
                }
                if (cookieValue == null) continue;
                TraceCollector.addTag((String)cookieKey, cookieValue);
            }
        }
    }

    public static void saveAsyncData(TransformAccess args) {
        Object context = args.getLopsAttribute();
        if (context != null && context instanceof RequestContext) {
            SpanEvent spanEvent = ((RequestContext)context).getSpanEvent();
            Map map = ((RequestContext)context).getMap();
            List txName = ((RequestContext)context).getTxName();
            String gTraceId = ((RequestContext)context).getgTraceId();
            String userFlag = ((RequestContext)context).getUserFlag();
            args.setLopsAttribute(null);
            TraceCollector.setSpanEvent((SpanEvent)spanEvent);
            TraceCollector.USER_FLAG_THREAD_LOCAL.set(userFlag);
            TraceCollector.G_TRACE_ID_THREAD_LOCAL.set(gTraceId);
            UrlStatsCollector.setThreadLocalMap((Map)map);
            TransactionCollector.setTxName((List)txName);
        }
    }

    public static void clearAsyncData(TransformAccess args) {
        SpanEvent spanEvent = TraceCollector.getSpanEvent();
        Map map = UrlStatsCollector.getThreadLocalMap();
        List txName = TransactionCollector.getTxName();
        TraceCollector.clear();
        TransactionCollector.clear();
        UrlStatsCollector.clearThreadLocal();
        RequestContext requestContext = new RequestContext();
        requestContext.setSpanEvent(spanEvent);
        requestContext.setMap(map);
        requestContext.setTxName(txName);
        args.setLopsAttribute((Object)requestContext);
    }
}

