/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.mongodb.MongoUtils;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;

public class ConnectionOpenInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                TraceCollector.onStart((String)className, (String)methodName, (String)"MongoDb");
            }
        }
        catch (Exception createConnectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)createConnectionException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                MongoDbCollector.onException(e);
                TraceCollector.onError((Throwable)e);
            }
        }
        catch (Exception createConnectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)createConnectionException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (MongoDbCollector.INSTANCE.isEnable()) {
                TraceCollector.onFinally();
                MongoDbCollector.connectionOpen(MongoUtils.getConnectionAddress(object));
            }
        }
        catch (Exception createConnectionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)createConnectionException);
        }
    }
}

