/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.plugin.mongodb.ConnectionCloseReason;
import com.lubanops.apm.plugin.mongodb.MongoUtils;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;

public class ConnectionCloseInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        block4: {
            try {
                if (!MongoDbCollector.INSTANCE.isEnable()) break block4;
                Object connection = args[0];
                String host = MongoUtils.getConnectionAddress(connection);
                ConnectionCloseReason reason = ConnectionCloseReason.UNKNOWN;
                try {
                    reason = MongoUtils.getConnectionCloseReason(connection);
                }
                catch (Exception e) {
                    LogFactory.getLogger().log(Level.SEVERE, "Unsupported Mongo Driver Version.", (Throwable)e);
                }
                MongoDbCollector.connectionClose(host, reason);
            }
            catch (Exception closeConnectionException) {
                LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)closeConnectionException);
            }
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

