/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.mongodb;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.plugin.mongodb.MongoParser;
import com.lubanops.apm.plugin.mongodb.MongoStatsConfig;
import com.lubanops.apm.plugin.mongodb.collector.MongoDbCollector;
import com.mongodb.MongoNamespace;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;

public class MongoContext {
    public static final String MONGO_DB = "MongoDB";
    public static final String CLUSTER_ID = "clusterId";
    public static final String CLUSTER_SETTING = "setting";
    public static final String MONGO_HOST = "host";
    public static final String MONGO_HOSTS = "hosts";
    public static final String POOL_AVAILABLE_COUNT = "availableCount";
    public static final String POOL_IN_USE_COUNT = "inUseCount";
    public static final String POOL_MAX_SIZE = "maxSize";
    public static final String POOL_MIN_SIZE = "minSize";
    public static final String POOL_MAX_WAIT_QUEUE_SIZE = "maxWaitQueueSize";
    public static final String POOL_MAX_WAIT_TIME = "maxWaitTimeMs";
    public static final String POOL_MAX_CONNECTION_LIFE = "maxConnectionLifeTimeMs";
    public static final String POOL_MAX_CONNECTION_IDLE = "maxConnectionIdleTimeMs";
    public static final String RESULT = "Result";
    public static final String CURSOR = "cursor";
    public static final String FIRST_BATCH = "firstBatch";
    public static final String NEXT_BATCH = "nextBatch";
    public static final String N = "n";
    public static final String N_MODIFIED = "nModified";
    public static final String LAST_ERROR_OBJECT = "lastErrorObject";
    public static final String UPSERTED = "upserted";
    public static final String COUNTS = "counts";
    public static final String OUTPUT = "output";
    public static final String QUERY_COUNT = "query count";
    public static final String UPDATE_COUNT = "update count";
    public static final String NAMESPACE = "namespace";
    public static final String FILTER = "filter";
    public static final String COMMAND = "command";
    public static final String ORIGINAL_COMMAND = "original command";
    public static final String PIPELINE = "pipeline";
    public static final ThreadLocal<Object> OPERATION_LOCAL = new ThreadLocal();

    public static String getNamespace() {
        Object operation = OPERATION_LOCAL.get();
        String namespace = "?";
        if (operation instanceof AttributeAccess) {
            Object[] fields = ((AttributeAccess)operation).getLopsFileds();
            if (fields[0] != null && fields[0] instanceof MongoNamespace) {
                namespace = fields[0].toString();
            } else if (fields[1] != null && fields[1] instanceof String) {
                namespace = fields[1].toString();
            }
        }
        return namespace;
    }

    public static String[] buildStatsArgs() {
        Object operation = OPERATION_LOCAL.get();
        String namespace = "?";
        String operationArgs = "?";
        String originalOperationArgs = null;
        if (operation instanceof AttributeAccess) {
            Object[] fields = ((AttributeAccess)operation).getLopsFileds();
            if (fields[0] != null && fields[0] instanceof MongoNamespace) {
                namespace = fields[0].toString();
            } else if (fields[1] != null && fields[1] instanceof String) {
                namespace = fields[1].toString();
            }
            if (fields[2] != null && fields[2] instanceof BsonDocument) {
                operationArgs = "filter: " + MongoParser.bsonValueToString((BsonValue)((BsonDocument)fields[2]), MongoDbCollector.getMaximumCommandLength(), false);
                if (MongoStatsConfig.isParseOriginalCommand) {
                    originalOperationArgs = "filter: " + MongoParser.bsonValueToString((BsonValue)((BsonDocument)fields[2]), MongoDbCollector.getMaximumCommandLength(), true);
                }
            } else if (fields[3] != null && fields[3] instanceof List) {
                operationArgs = "pipeline: " + MongoParser.parseBsonDocumentList((List)fields[3], MongoDbCollector.getMaximumCommandLength(), false);
                if (MongoStatsConfig.isParseOriginalCommand) {
                    originalOperationArgs = "pipeline: " + MongoParser.parseBsonDocumentList((List)fields[3], MongoDbCollector.getMaximumCommandLength(), true);
                }
            } else if (fields[4] != null && fields[4] instanceof BsonDocument) {
                operationArgs = "command: " + MongoParser.bsonValueToString((BsonValue)((BsonDocument)fields[4]), MongoDbCollector.getMaximumCommandLength(), false);
                if (MongoStatsConfig.isParseOriginalCommand) {
                    originalOperationArgs = "command: " + MongoParser.bsonValueToString((BsonValue)((BsonDocument)fields[4]), MongoDbCollector.getMaximumCommandLength(), true);
                }
            }
        }
        return new String[]{namespace, operationArgs, originalOperationArgs};
    }
}

