/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.lettuce.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.collector.api.FutureStatsAccessor;
import com.lubanops.apm.bootstrap.otel.ConstantsTrace;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.Tags;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.AgentUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.redis.collector.RedisCollector;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTags;
import com.lubanops.apm.plugin.redis.collector.commons.RedisTransformHelper;
import io.lettuce.core.protocol.Command;
import io.lettuce.core.protocol.CompleteableCommand;
import io.lettuce.core.protocol.DecoratedCommand;
import io.lettuce.core.protocol.RedisCommand;
import io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.api.trace.Span;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class WriteSingleCommandInterceptor
implements Interceptor {
    public static final int BLOB_THRESHOLD = 1000;
    public boolean compatibleFlag = Boolean.FALSE;

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return null;
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        if (RedisCollector.getInstance().isEnable()) {
            TraceCollector.onError((Throwable)e);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        RedisCommand command = (RedisCommand)args[1];
        String method = command.getType().name();
        if (RedisCollector.getInstance().isEnable()) {
            Command localCommand = this.findRootCommand(command);
            if (localCommand == null) {
                return;
            }
            String hostAndPort = ((ChannelHandlerContext)args[0]).channel().remoteAddress().toString();
            if (hostAndPort.indexOf("/") == 0) {
                hostAndPort = hostAndPort.substring(1);
            }
            if (args[1] instanceof CompleteableCommand) {
                TransformAccess transformAccess = (TransformAccess)localCommand;
                FutureStatsAccessor futureStatsAccessor = (FutureStatsAccessor)transformAccess.getLopsAttribute();
                SpanEvent spanEvent = null;
                if (futureStatsAccessor != null && futureStatsAccessor.getSpanEvent() != null) {
                    spanEvent = futureStatsAccessor.getSpanEvent();
                }
                CompleteableCommand completableCommand = (CompleteableCommand)command;
                if (this.compatibleFlag) {
                    completableCommand.onComplete((Consumer)new OnCompleteConsumer(method, hostAndPort, command, spanEvent, result, System.nanoTime()));
                    return;
                }
                try {
                    completableCommand.onComplete((BiConsumer)new OnCompleteConsumer(method, hostAndPort, command, spanEvent, result, System.nanoTime()));
                }
                catch (NoSuchMethodError error) {
                    completableCommand.onComplete((Consumer)new OnCompleteConsumer(method, hostAndPort, command, spanEvent, result, System.nanoTime()));
                    this.compatibleFlag = Boolean.TRUE;
                }
            }
        }
    }

    private Command findRootCommand(RedisCommand command) {
        if (command instanceof Command) {
            return (Command)command;
        }
        if (command instanceof DecoratedCommand) {
            return this.findRootCommand(((DecoratedCommand)command).getDelegate());
        }
        return null;
    }

    private String convert(Object sourceObj) {
        byte[] sourceObjByte;
        String desStr = "";
        if (sourceObj == null) {
            return desStr;
        }
        desStr = sourceObj instanceof byte[] ? ((sourceObjByte = (byte[])sourceObj).length > 200 ? String.format("[APM BLOB OBJECT][%d]", sourceObjByte.length) : new String(sourceObjByte)) : (sourceObj instanceof Number || sourceObj instanceof Boolean ? sourceObj.toString() : (sourceObj instanceof String ? (StringUtils.isBlank((String)(desStr = (String)sourceObj)) ? "" : (desStr.length() > 100 ? String.format("[%s...][APM BLOB OBJECT][%d]", desStr.substring(0, 100), desStr.length()) : desStr)) : (sourceObj.getClass().isPrimitive() ? sourceObj + "" : "[APM UNKNOWN OBJECT][" + sourceObj.getClass().getSimpleName() + "]")));
        return desStr;
    }

    private class OnCompleteConsumer
    implements BiConsumer<Object, Throwable>,
    Consumer {
        private String method;
        private String hostAndPort;
        private RedisCommand command;
        private SpanEvent spanEvent;
        private Object result;
        private long startTime;

        public OnCompleteConsumer(String method, String hostAndPort, RedisCommand command, SpanEvent spanEvent, Object result, long startTime) {
            this.method = method;
            this.hostAndPort = hostAndPort;
            this.command = command;
            this.spanEvent = spanEvent;
            this.result = result;
            this.startTime = startTime;
        }

        @Override
        public void accept(Object o, Throwable throwable) {
            try {
                String option = this.command.getType().name();
                boolean isBlob = false;
                long resultSize = AgentUtils.getObjectSize((Object)this.result);
                long argurmentsSize = AgentUtils.getObjectSize((Object)this.command.getArgs());
                if (resultSize > 1024L) {
                    isBlob = true;
                    if (this.spanEvent != null) {
                        this.spanEvent.addTag(RedisTags.resultSize.name(), resultSize + "");
                    }
                }
                if (argurmentsSize > 1024L) {
                    isBlob = true;
                    if (this.spanEvent != null) {
                        this.spanEvent.addTag(RedisTags.argsSize.name(), argurmentsSize + "");
                    }
                }
                if (this.spanEvent != null) {
                    this.spanEvent.setAsync(true);
                    this.spanEvent.addTag(RedisTags.option.name(), option);
                    if (RedisTransformHelper.needParseBody(option) && RedisCollector.getInstance().isRedisParseBody()) {
                        this.spanEvent.addTag(RedisTags.args.name(), this.command.getArgs().toCommandString(), RedisCollector.getInstance().getParseRedisLength());
                    }
                    long timeUsedNano = System.nanoTime() - this.startTime;
                    this.spanEvent.addTag(Tags.asyncTimeUsed.name(), String.valueOf(timeUsedNano / 1000000L));
                    this.spanEvent.setTimeUsed(timeUsedNano);
                    this.spanEvent.addTag(RedisTags.host.name(), this.hostAndPort);
                    this.spanEvent.addTag(RedisTags.blob.name(), isBlob + "");
                    Span otelSpan = this.spanEvent.getOtelSpan();
                    if (otelSpan != null) {
                        TraceCollector.addOtelAttribute((Span)otelSpan, (String)ConstantsTrace.AttributeDBSystem.toString(), (Object)ConstantsTrace.AttributeDBSystemRedis.toString());
                        TraceCollector.addOtelAttribute((Span)otelSpan, (String)ConstantsTrace.AttributeDBStatement.toString(), (Object)option);
                        TraceCollector.addOtelAttribute((Span)otelSpan, (String)ConstantsTrace.AttributeDBConnectionString.toString(), (Object)this.hostAndPort);
                    }
                }
                this.acceptSpanEvent(throwable, option, isBlob, resultSize, argurmentsSize);
            }
            catch (Throwable e) {
                TraceCollector.onError((SpanEvent)this.spanEvent, (Throwable)e);
            }
            if (this.spanEvent != null) {
                TraceCollector.sendSpanEvent((SpanEvent)this.spanEvent);
            }
        }

        private void acceptSpanEvent(Throwable throwable, String option, boolean isBlob, long resultSize, long argsSize) {
            String traceId = null;
            if (this.spanEvent != null) {
                traceId = this.spanEvent.getTraceId();
            }
            if (throwable != null) {
                RedisCollector.onThrowableAsync(this.method, this.hostAndPort, throwable, traceId);
                TraceCollector.onError((SpanEvent)this.spanEvent, (Throwable)throwable);
            } else if (this.command.getOutput() != null) {
                String error = this.command.getOutput().getError();
                if (error != null) {
                    RuntimeException errorWrap = new RuntimeException(error);
                    RedisCollector.onThrowableAsync(this.method, this.hostAndPort, errorWrap, traceId);
                    TraceCollector.onError((SpanEvent)this.spanEvent, (Throwable)errorWrap);
                } else {
                    this.doSuccess(option, isBlob, resultSize, argsSize);
                }
            }
        }

        private void doSuccess(String option, boolean isBlob, long resultSize, long argsSize) {
            String traceId = null;
            if (this.spanEvent != null) {
                traceId = this.spanEvent.getTraceId();
            }
            Object commandResult = this.command.getOutput().get();
            String resultStr = WriteSingleCommandInterceptor.this.convert(commandResult);
            if (RedisTransformHelper.needParseBody(option) && RedisCollector.getInstance().isRedisParseBody() && this.spanEvent != null) {
                this.spanEvent.addTag(RedisTags.result.name(), resultStr, RedisCollector.getInstance().getParseRedisLength());
            }
            if (RedisTransformHelper.HIT_METHOD_SET.contains(this.method.toLowerCase())) {
                boolean hit = RedisTransformHelper.isHit(commandResult, this.method, commandResult == null ? "" : resultStr);
                RedisCollector.onFinallyAsync(this.method, this.hostAndPort, this.startTime, hit, isBlob, resultSize + argsSize, traceId, true);
                if (this.spanEvent != null) {
                    if (hit) {
                        this.spanEvent.addTag(RedisTags.hit.name(), "true");
                    } else {
                        this.spanEvent.addTag(RedisTags.hit.name(), "false");
                    }
                }
            } else {
                RedisCollector.onFinallyAsync(this.method, this.hostAndPort, this.startTime, isBlob, resultSize + argsSize, traceId);
            }
        }

        public void accept(Object o) {
            this.accept(o, null);
        }
    }
}

