/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.c3p0.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.connectionpool.ConnectionPoolUtils;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.Util;
import com.lubanops.apm.plugin.c3p0.collector.C3P0Collector;
import com.mchange.v2.c3p0.ComboPooledDataSource;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.jboss.C3P0PooledDataSource;
import java.security.ProtectionDomain;

public class GetConnectionInterceptor
implements Interceptor {
    private static final String C3P0_BEFORE_GET_CONNECTION = "beforeGetConnection";
    private static final String C3P0_AFTER_GET_CONNECTION = "AfterGetConnection";
    private static final String ACTIVE_COUNT = "activeCount";
    private static final String POOLING_COUNT = "poolingCount";
    private static final String WAIT_THREAD_COUNT = "waitThreadCount";

    public GetConnectionInterceptor() {
        C3P0Collector.setDriverVersion(Util.getJarVersionFromProtectionDomain((ProtectionDomain)C3P0PooledDataSource.class.getProtectionDomain()));
    }

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (C3P0Collector.INSTANCE.isEnable()) {
                int waitingThreadCount;
                int poolingCount;
                int activeCount;
                ComboPooledDataSource dataSource = (ComboPooledDataSource)object;
                C3P0PooledConnectionPoolManager manager = (C3P0PooledConnectionPoolManager)((AttributeAccess)object).getLopsFileds()[0];
                if (manager != null) {
                    activeCount = dataSource.getNumBusyConnections();
                    poolingCount = dataSource.getNumIdleConnections();
                    waitingThreadCount = dataSource.getNumThreadsAwaitingCheckoutDefaultUser();
                } else {
                    activeCount = 0;
                    poolingCount = 0;
                    waitingThreadCount = 0;
                }
                C3P0Collector.INSTANCE.setCounts(activeCount, poolingCount, waitingThreadCount);
                C3P0Collector.onStart(dataSource);
                TraceCollector.onStart((String)className, (String)methodName, (String)"C3P0");
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (C3P0Collector.INSTANCE.isEnable()) {
                C3P0Collector.onThrowable(e);
                ConnectionPoolUtils.setErrorMsg((Throwable)e);
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (C3P0Collector.INSTANCE.isEnable()) {
                C3P0Collector.onFinally();
                SpanEvent spanEvent = TraceCollector.onFinally((boolean)false);
                if (spanEvent != null && (spanEvent.getChildrenEventCount() > 0 || spanEvent.getTimeUsed() >= (long)C3P0Collector.INSTANCE.getTimeSpanThreshold() || spanEvent.getHasError())) {
                    if (C3P0Collector.INSTANCE.isGetPoolInfo()) {
                        Integer activeCountBefore = C3P0Collector.INSTANCE.getActiveCount();
                        Integer poolingCountBefore = C3P0Collector.INSTANCE.getPoolingCount();
                        Integer waitThreadCountBefore = C3P0Collector.INSTANCE.getWaitThreadCount();
                        C3P0Collector.INSTANCE.clearCounts();
                        if (poolingCountBefore != null && waitThreadCountBefore != null) {
                            ComboPooledDataSource dataSource = (ComboPooledDataSource)object;
                            int activeCountAfter = dataSource.getNumBusyConnections();
                            int poolingCountAfter = dataSource.getNumIdleConnections();
                            int waitThreadCountAfter = dataSource.getNumThreadsAwaitingCheckoutDefaultUser();
                            String c3p0BeforeContext = "activeCount: " + activeCountBefore + "\n" + POOLING_COUNT + ": " + poolingCountBefore + "\n" + WAIT_THREAD_COUNT + ": " + waitThreadCountBefore;
                            String c3p0AfterContext = "activeCount: " + activeCountAfter + "\n" + POOLING_COUNT + ": " + poolingCountAfter + "\n" + WAIT_THREAD_COUNT + ": " + waitThreadCountAfter;
                            spanEvent.addTag(C3P0_BEFORE_GET_CONNECTION, c3p0BeforeContext);
                            spanEvent.addTag(C3P0_AFTER_GET_CONNECTION, c3p0AfterContext);
                        }
                    }
                    TraceCollector.sendSpanEvent((SpanEvent)spanEvent);
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

