/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.util;

import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.io.UnsupportedEncodingException;
import java.util.Set;

public class HttpUtils {
    public static String getCookieValue(Set<Cookie> cookies, String cookieName) {
        for (Cookie cookie : cookies) {
            if (!cookie.name().equals(cookieName)) continue;
            return cookie.value();
        }
        return null;
    }

    public static void setCookie(DefaultFullHttpResponse response, String name, String value) {
        response.headers().add((CharSequence)HttpHeaderNames.SET_COOKIE, (Object)ServerCookieEncoder.STRICT.encode(name, value));
    }

    public static DefaultHttpResponse createResponse(FullHttpRequest request, HttpResponseStatus status, String content) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), status);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html; charset=utf-8");
        try {
            response.content().writeBytes(content.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return response;
    }

    public static HttpResponse createRedirectResponse(FullHttpRequest request, String url) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.FOUND);
        response.headers().set((CharSequence)HttpHeaderNames.LOCATION, (Object)url);
        return response;
    }
}

