/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.arthas.core.advisor;

import com.taobao.arthas.core.advisor.Advice;
import com.taobao.arthas.core.advisor.AdviceListener;
import com.taobao.arthas.core.advisor.ArthasMethod;
import com.taobao.arthas.core.command.express.ExpressException;
import com.taobao.arthas.core.command.express.ExpressFactory;
import com.taobao.arthas.core.shell.command.CommandProcess;
import com.taobao.arthas.core.shell.system.Process;
import com.taobao.arthas.core.shell.system.ProcessAware;
import com.taobao.arthas.core.util.StringUtils;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AdviceListenerAdapter
implements AdviceListener,
ProcessAware {
    private static final AtomicLong ID_GENERATOR = new AtomicLong(0L);
    private Process process;
    private long id = ID_GENERATOR.addAndGet(1L);
    private boolean verbose;

    @Override
    public long id() {
        return this.id;
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public Process getProcess() {
        return this.process;
    }

    @Override
    public void setProcess(Process process) {
        this.process = process;
    }

    @Override
    public final void before(Class<?> clazz, String methodName, String methodDesc, Object target, Object[] args) throws Throwable {
        this.before(clazz.getClassLoader(), clazz, new ArthasMethod(clazz, methodName, methodDesc), target, args);
    }

    @Override
    public final void afterReturning(Class<?> clazz, String methodName, String methodDesc, Object target, Object[] args, Object returnObject) throws Throwable {
        this.afterReturning(clazz.getClassLoader(), clazz, new ArthasMethod(clazz, methodName, methodDesc), target, args, returnObject);
    }

    @Override
    public final void afterThrowing(Class<?> clazz, String methodName, String methodDesc, Object target, Object[] args, Throwable throwable) throws Throwable {
        this.afterThrowing(clazz.getClassLoader(), clazz, new ArthasMethod(clazz, methodName, methodDesc), target, args, throwable);
    }

    public abstract void before(ClassLoader var1, Class<?> var2, ArthasMethod var3, Object var4, Object[] var5) throws Throwable;

    public abstract void afterReturning(ClassLoader var1, Class<?> var2, ArthasMethod var3, Object var4, Object[] var5, Object var6) throws Throwable;

    public abstract void afterThrowing(ClassLoader var1, Class<?> var2, ArthasMethod var3, Object var4, Object[] var5, Throwable var6) throws Throwable;

    protected boolean isConditionMet(String conditionExpress, Advice advice, double cost) throws ExpressException {
        return StringUtils.isEmpty(conditionExpress) || ExpressFactory.threadLocalExpress(advice).bind("cost", cost).is(conditionExpress);
    }

    protected Object getExpressionResult(String express, Advice advice, double cost) throws ExpressException {
        return ExpressFactory.threadLocalExpress(advice).bind("cost", cost).get(express);
    }

    protected boolean isLimitExceeded(int limit, int currentTimes) {
        return currentTimes >= limit;
    }

    protected void abortProcess(CommandProcess process, int limit) {
        process.write("Command execution times exceed limit: " + limit + ", so command will exit. You can set it with -n option.\n");
        process.end();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

