/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsRestClientCollector;

public class RecursiveAsyncRequestInterceptor
implements Interceptor {
    private static final String LISTENER_CLASS_NAME = "org.elasticsearch.client.RestClient$FailureTrackingResponseListener";
    private final ThreadLocal<Boolean> isRecursiveCallLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (EsRestClientCollector.INSTANCE.isEnable() && TraceCollector.getSpanEvent() == null) {
                Object listener;
                if (args[2].getClass().getName().equals(LISTENER_CLASS_NAME)) {
                    listener = args[2];
                } else if (args[5].getClass().getName().equals(LISTENER_CLASS_NAME)) {
                    listener = args[5];
                } else if (args[6].getClass().getName().equals(LISTENER_CLASS_NAME)) {
                    listener = args[6];
                } else {
                    return new Object[0];
                }
                this.isRecursiveCallLocal.set(Boolean.TRUE);
                SpanEvent spanEvent = (SpanEvent)TransformAccessUtils.getFromLopsAttributeMap((Object)listener, (String)"spanEvent");
                TraceCollector.setSpanEvent((SpanEvent)spanEvent);
                EsUtils.saveUrlInfoLocalsFromObj(listener);
            }
        }
        catch (Exception recursiveAsyncException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)recursiveAsyncException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            Boolean isRecursiveCall;
            if (EsRestClientCollector.INSTANCE.isEnable() && (isRecursiveCall = this.isRecursiveCallLocal.get()) != null && isRecursiveCall.equals(Boolean.TRUE)) {
                this.isRecursiveCallLocal.remove();
                TraceCollector.setSpanEvent(null);
            }
        }
        catch (Exception recursiveAsyncException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)recursiveAsyncException);
        }
    }
}

