/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.elasticsearch.restclient.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.config.IdentityConfigManager;
import com.lubanops.apm.bootstrap.plugin.common.DefaultExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultServerNodeAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultStatusCodeAggregator;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.InvocationAggregator;
import com.lubanops.apm.bootstrap.transaction.TransactionCollector;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.elasticsearch.restclient.EsUtils;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsClientAggregator;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsClientInfoAggregator;
import com.lubanops.apm.plugin.elasticsearch.restclient.collector.EsClusterAggregator;
import com.lubanops.apm.plugin.elasticsearch.restclient.stats.EsClientStats;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpHost;

public class EsRestClientCollector
extends Collector {
    public static final EsRestClientCollector INSTANCE = new EsRestClientCollector();
    private static final EsClientAggregator ES_CLIENT_AGGREGATOR = new EsClientAggregator();
    private static final EsClientInfoAggregator ES_CLIENT_INFO_AGGREGATOR = new EsClientInfoAggregator();
    private static final InvocationAggregator INVOCATION_AGGREGATOR = new InvocationAggregator();
    private static final DefaultStatusCodeAggregator STATUS_CODE_AGGREGATOR = new DefaultStatusCodeAggregator();
    private static final DefaultServerNodeAggregator SERVER_NODE_AGGREGATOR = new DefaultServerNodeAggregator();
    private static final EsClusterAggregator ES_CLUSTER_AGGREGATOR = new EsClusterAggregator();
    private static final DefaultExceptionAggregator EXCEPTION_AGGREGATOR = new DefaultExceptionAggregator();
    private static final int EXPECTED_ERROR_CODE = 400;

    public void parseParameter(Map<String, String> parameters) {
        List list = (List)ParameterParseUtil.getParameterValue(parameters, (String)"EsIndexRegexReformat", List.class, EsUtils.RegexConversionPattern.class);
        if (list != null) {
            EsUtils.setIndexRegexTargetMap(list);
        }
    }

    public static boolean isRestClientHighThanOrEqualTo63() {
        return ES_CLIENT_INFO_AGGREGATOR.isRestClientHighThanOrEqual63();
    }

    public static boolean isRestClientHighThanOrEqualTo64() {
        return ES_CLIENT_INFO_AGGREGATOR.isRestClientHighThanOrEqual64();
    }

    public static boolean isRestClientHighThanOrEqualTo70() {
        return ES_CLIENT_INFO_AGGREGATOR.isRestClientHighThanOrEqual70();
    }

    public static String getRestClientVersion() {
        return ES_CLIENT_INFO_AGGREGATOR.getRestClientVersion();
    }

    public static String getRestHighLevelClientVersion() {
        return ES_CLIENT_INFO_AGGREGATOR.getRestHighLevelClientVersion();
    }

    public static void setRestClientVersion(String version) {
        ES_CLIENT_INFO_AGGREGATOR.setRestClientVersion(version);
    }

    public static void setRestHighLevelClientVersion(String version) {
        ES_CLIENT_INFO_AGGREGATOR.setRestHighLevelClientVersion(version);
    }

    public static EsClientStats onStart(String clientId, String url, String method) {
        return ES_CLIENT_AGGREGATOR.onStart(clientId, url, method);
    }

    public static Map<String, Object> onStartAsync(String clientId, String url, String method) {
        return ES_CLIENT_AGGREGATOR.onStartAsync(clientId, url, method);
    }

    public static void onStatusCodeAsync(String url, int code, Map<String, Object> map, String traceId) {
        STATUS_CODE_AGGREGATOR.onStatusCode(url, code);
        if (code >= 400) {
            INVOCATION_AGGREGATOR.onErrorAsync(map, traceId);
        }
    }

    public static void onResponseClose() {
        ES_CLIENT_AGGREGATOR.onResponseClose();
    }

    public static void onResponseCloseAsync(Long startTime, EsClientStats stats, String traceId) {
        ES_CLIENT_AGGREGATOR.onResponseCloseAsync(startTime, stats, traceId);
    }

    public static void onException(Throwable throwable) {
        EXCEPTION_AGGREGATOR.onThrowable(throwable);
    }

    public static void onDefinitiveFailure() {
        ES_CLIENT_AGGREGATOR.onDefinitiveFailure();
    }

    public static void onTrackFailure() {
        ES_CLIENT_AGGREGATOR.onTrackFailure();
    }

    public static void onDefinitiveFailureAsync(EsClientStats stats, String traceId) {
        ES_CLIENT_AGGREGATOR.onDefinitiveFailureAsync(stats, traceId);
    }

    public static void onTrackFailureAsync(EsClientStats stats) {
        ES_CLIENT_AGGREGATOR.onTrackFailureAsync(stats);
    }

    public static Map<String, Object> httpclientOnStartAsync(HttpHost host, String requestUri, String method, String esOrderedNodes, String clientType) {
        Map<String, Object> map = new HashMap<String, Object>();
        String hostAddress = EsUtils.getHostAddress(host);
        SERVER_NODE_AGGREGATOR.onStart(hostAddress);
        String targetUrl = EsUtils.convertEndpoint(requestUri);
        if (targetUrl != null) {
            map = INVOCATION_AGGREGATOR.onStartAsync(host.toURI(), targetUrl, method, clientType);
        }
        map.put("isInEs", Boolean.TRUE);
        map.put("serverAddr", hostAddress);
        map.put("esClusterNodes", esOrderedNodes);
        ES_CLUSTER_AGGREGATOR.onStartAsync(esOrderedNodes, map);
        return map;
    }

    public static void httpclientOnResponseCloseAsync(Map<String, Object> map, String traceId) {
        INVOCATION_AGGREGATOR.onResponseCloseAsyncWithoutTx(null, map, traceId);
        Long timeUsed = (Long)SERVER_NODE_AGGREGATOR.onFinallyAsync((String)map.get("serverAddr"), (Long)map.get("starttime"), traceId).get("serverAddrTimeUsed");
        if (timeUsed != null) {
            Boolean hasError = (Boolean)map.get("serverAddrErr");
            if (hasError == null) {
                hasError = Boolean.FALSE;
            }
            TransactionCollector.collect((long)timeUsed, (boolean)hasError, (String)String.valueOf(IdentityConfigManager.getEnvId()), (String)("Elasticsearch:" + map.get("esClusterNodes")), (List)((List)map.get("txName")), (String)"EsRestClient");
        }
        ES_CLUSTER_AGGREGATOR.onFinallyAsync(map);
    }

    public static void httpclientOnError(Map<String, Object> map, String traceId) {
        INVOCATION_AGGREGATOR.onErrorAsync(map, traceId);
        Boolean hasError = SERVER_NODE_AGGREGATOR.onErrorAsync((String)map.get("serverAddr"), traceId);
        map.put("serverAddrErr", hasError);
        ES_CLUSTER_AGGREGATOR.onErrorAsync(map, traceId);
    }

    public String getCollectorName() {
        return "EsRestClient";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)ES_CLIENT_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)ES_CLIENT_INFO_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)INVOCATION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)STATUS_CODE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)SERVER_NODE_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)ES_CLUSTER_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

