/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jetcd.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.TransformAccessUtils;
import com.lubanops.apm.plugin.jetcd.JetcdContext;
import com.lubanops.apm.plugin.jetcd.JetcdServiceType;
import com.lubanops.apm.plugin.jetcd.collector.JetcdCollector;
import com.lubanops.apm.plugin.jetcd.interceptor.RequestProcessHelper;
import java.util.Map;

public class KVRequestInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (JetcdCollector.INSTANCE.isEnable()) {
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                String endpoints = (String)TransformAccessUtils.getFromLopsAttributeMap((Object)object, (String)"endpoints");
                if (spanEvent != null) {
                    spanEvent.addTag("endpoints", endpoints);
                }
                JetcdServiceType serviceType = JetcdServiceType.KV;
                JetcdContext.SERVICE_TYPE_LOCAL.set(serviceType);
                String requestType = RequestProcessHelper.parseAndProcessRequest(args[0], spanEvent, JetcdServiceType.KV);
                if (requestType != null) {
                    if (spanEvent != null) {
                        spanEvent.setMethod(spanEvent.getMethod() + "(" + requestType + ")");
                    }
                    Map<String, Object> context = JetcdCollector.onRequestStartAsync(endpoints, requestType);
                    context.put("serviceType", (Object)serviceType);
                    JetcdContext.COLLECTOR_CONTEXT_LOCAL.set(context);
                }
            }
        }
        catch (Exception kvRequestException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)kvRequestException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
    }
}

