/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.obsclient.collector;

import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.ExcludePluginLocal;
import com.lubanops.apm.plugin.obsclient.stats.ObsClientStats;
import java.util.Arrays;
import java.util.List;

public class ObsClientInvocationAggregator
extends MultiPrimaryKeyAggregator<ObsClientStats> {
    private ThreadLocal<ObsClientStats> statsLocal = new ThreadLocal();
    private ThreadLocal<Long> timeLocal = new ThreadLocal();
    private ThreadLocal<String> endPointLocal = new ThreadLocal();

    public void onStart(String hostUri, String requestUri, String method) {
        ObsClientStats stats = (ObsClientStats)this.getValue(new String[]{requestUri, method});
        this.statsLocal.set(stats);
        this.timeLocal.set(stats.onStart());
        this.endPointLocal.set(hostUri);
    }

    public boolean onThrowable(Throwable t) {
        ObsClientStats stats = this.statsLocal.get();
        Long start = this.timeLocal.get();
        if (stats != null && start != null) {
            stats.onThrowable(t);
            return true;
        }
        return false;
    }

    public long onFinally() {
        ObsClientStats stats = this.statsLocal.get();
        Long startTime = this.timeLocal.get();
        long usedTime = System.nanoTime() - startTime;
        if (stats != null && startTime != null) {
            stats.onFinally(usedTime);
        }
        return usedTime;
    }

    public boolean onError() {
        ObsClientStats stats = this.statsLocal.get();
        return stats != null;
    }

    public void clearThreadLocal() {
        super.clearThreadLocal();
        this.statsLocal.remove();
        this.timeLocal.remove();
        this.endPointLocal.remove();
        ExcludePluginLocal.EXCLUDE_PLUGIN_FLAG.remove();
    }

    protected Class<ObsClientStats> getValueType() {
        return ObsClientStats.class;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("url", "method");
    }

    public String getName() {
        return "obsClientInvocation";
    }

    public String getHost() {
        return this.endPointLocal.get();
    }
}

