/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.websocket.collector;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.plugin.common.url.UrlAggregator;
import com.lubanops.apm.plugin.websocket.collector.MessageStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageAggregator
extends UrlAggregator<MessageStats> {
    public static final String STARTTIME_KEY = "wsStartTime";

    public String getName() {
        return "message";
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public void createSession(String url) {
        MessageStats messageStats = (MessageStats)this.getValue(new String[]{url});
        messageStats.createSession();
    }

    public void closeSession(String url, String closeReason) {
        MessageStats messageStats = (MessageStats)this.getValue(new String[]{url});
        messageStats.closeSession(closeReason);
    }

    public String getUrlKey() {
        return "url";
    }

    protected int primaryKeyLength() {
        return 1;
    }

    protected List<String> primaryKey() {
        return Arrays.asList("url");
    }

    protected Class<MessageStats> getValueType() {
        return MessageStats.class;
    }

    public void onStart(String url, long traffic) {
        MessageStats messageStats = (MessageStats)this.getValue(new String[]{url});
        if (messageStats != null) {
            messageStats.incrementTraffic(traffic);
            long startTime = messageStats.onStart();
            this.getContextMap().put(STARTTIME_KEY, startTime);
        }
    }

    public void onError(String url) {
        MessageStats messageStats = (MessageStats)this.getValue(new String[]{url});
        if (messageStats != null) {
            messageStats.onError();
        }
    }

    public void onFinally(String url) {
        MessageStats messageStats = (MessageStats)this.getValue(new String[]{url});
        if (messageStats != null) {
            long endTime = System.nanoTime();
            Long startTime = (Long)this.getContextMap().get(STARTTIME_KEY);
            if (startTime != null) {
                long useTime = endTime - startTime;
                messageStats.onFinally(useTime);
            }
        }
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        HashMap<String, List<MonitorDataRow>> result = new HashMap<String, List<MonitorDataRow>>();
        if (collected == null || collected.isEmpty()) {
            ArrayList<MonitorDataRow> totalRows = new ArrayList<MonitorDataRow>();
            MonitorDataRow row = new MonitorDataRow();
            row.put((Object)"invokeCount", (Object)0);
            row.put((Object)"errorCount", (Object)0);
            totalRows.add(row);
            result.put("total", totalRows);
            return result;
        }
        SV totalStats = new SV();
        this.buildSV(collected, totalStats);
        List<MonitorDataRow> totalRows = this.buildTotalRows(totalStats);
        result.put("total", totalRows);
        return result;
    }

    private List<MonitorDataRow> buildTotalRows(SV totalStats) {
        ArrayList<MonitorDataRow> totalRows = new ArrayList<MonitorDataRow>();
        MonitorDataRow row = new MonitorDataRow();
        row.put((Object)"invokeCount", (Object)totalStats.invokeCount);
        row.put((Object)"totalTime", (Object)totalStats.totalTime);
        row.put((Object)"errorCount", (Object)totalStats.errorCount);
        row.put((Object)"traffic", (Object)totalStats.traffic);
        row.put((Object)"createSessionCount", (Object)totalStats.createSessionCount);
        row.put((Object)"closeSessionCount", (Object)totalStats.closeSessionCount);
        totalRows.add(row);
        return totalRows;
    }

    private void buildSV(List<MonitorDataRow> collected, SV totalStats) {
        for (MonitorDataRow row : collected) {
            Integer closeSessionCount;
            Integer createSessionCount;
            Long traffic;
            Long totalTime;
            Long errorCount;
            Long invokeCount = (Long)row.get((Object)"invokeCount");
            if (invokeCount != null) {
                totalStats.invokeCount += invokeCount.longValue();
            }
            if ((errorCount = (Long)row.get((Object)"errorCount")) != null) {
                totalStats.errorCount += errorCount.longValue();
            }
            if ((totalTime = (Long)row.get((Object)"totalTime")) != null) {
                totalStats.totalTime += totalTime.longValue();
            }
            if ((traffic = (Long)row.get((Object)"traffic")) != null) {
                totalStats.traffic += traffic.longValue();
            }
            if ((createSessionCount = (Integer)row.get((Object)"createSessionCount")) != null) {
                totalStats.createSessionCount += createSessionCount.intValue();
            }
            if ((closeSessionCount = (Integer)row.get((Object)"closeSessionCount")) == null) continue;
            totalStats.closeSessionCount += closeSessionCount.intValue();
        }
    }

    public static class SV {
        public long invokeCount;
        public long totalTime;
        public long errorCount;
        public long traffic;
        public int createSessionCount;
        public int closeSessionCount;
    }
}

