/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jettyclient.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.plugin.httpclient.collector.HttpClientCollector;
import com.lubanops.apm.bootstrap.trace.Headers;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.jettyclient.JettyClientUtils;
import java.util.Map;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;

public class RequestCompleteInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HttpClientCollector.INSTANCE.isEnable()) {
                HttpExchange httpExchange = (HttpExchange)object;
                HttpRequest request = JettyClientUtils.getRequest(httpExchange);
                Throwable failure = (Throwable)args[0];
                if (request instanceof TransformAccess && failure != null) {
                    String envId = request.getHeaders().get(Headers.ENV_ID.getValue());
                    Map context = (Map)((TransformAccess)request).getLopsAttribute();
                    SpanEvent spanEvent = (SpanEvent)context.get("spanevent");
                    String traceId = spanEvent == null ? null : spanEvent.getTraceId();
                    TraceCollector.onError((SpanEvent)spanEvent, (Throwable)failure);
                    HttpClientCollector.onThrowableAsync((Throwable)failure, (Map)context, (String)traceId);
                    HttpClientCollector.onResponseCloseAsync((String)envId, (Map)context, (String)traceId);
                    if (spanEvent != null) {
                        TraceCollector.onFinallySpanEvent((SpanEvent)spanEvent);
                    }
                }
            }
        }
        catch (Exception e1) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)e1);
        }
    }
}

