/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cloud.profiler.commons.pap.v1.converters;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class DynamicMessageAnalyzerHelper {
    private final Class<? extends Message> msgClass;
    private final Map<Class<?>, Integer> oneOfMessageTypeToIndex;
    private final List<Descriptors.FieldDescriptor> allFields;

    DynamicMessageAnalyzerHelper(Class<? extends Message> msgClass, Message samplePayload) {
        this.msgClass = msgClass;
        this.allFields = ((Descriptors.OneofDescriptor)samplePayload.getDescriptorForType().getOneofs().get(0)).getFields();
        this.oneOfMessageTypeToIndex = new HashMap(this.allFields.size());
        int size = this.allFields.size();
        for (int i = 0; i < size; ++i) {
            Class<?> cl = samplePayload.getField(this.allFields.get(i)).getClass();
            this.oneOfMessageTypeToIndex.put(cl, i);
        }
    }

    Descriptors.FieldDescriptor retrieveDynamicFieldDescriptor(Message innerMsg) {
        Class<?> msgType = innerMsg.getClass();
        Integer index = this.oneOfMessageTypeToIndex.get(msgType);
        if (index == null) {
            throw new IllegalArgumentException("Failed to reconstruct [ " + this.msgClass + " ] with Message of type [ " + msgType.getName() + " ]. Is it allowed in protobuf definition schema?");
        }
        return this.allFields.get(index);
    }
}

