/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.clientlogic;

import com.huawei.gaussdb.jdbc.jdbc.PgConnection;
import com.huawei.gaussdb.jdbc.jdbc.PgStatement;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.ClientLogicDecryptResult;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.LimitOffsetMetaData;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.SortColumnMetaData;
import com.huawei.gaussdb.jdbc.jdbc.clientlogic.TargetColumnMetaData;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import com.huawei.gaussdb.jdbc.util.JdbcBlackHole;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;

public class ClientLogicImpl {
    private static Log LOGGER = Logger.getLogger(ClientLogicImpl.class.getName());
    private static final String[] LIB_LIST = new String[]{"libkeyutils.so.1", "libkrb5support.so.0", "libk5crypto.so.3", "libstdc++.so.6", "libcrypto.so", "libcjson.so.1", "libcom_err.so.3", "libkrb5.so.3", "libgssapi_krb5.so.2", "libgssrpc.so.4", "libssl.so", "libcurl.so.4", "libkmc.so", "libgs_ktool.so", "libpq_ce.so.5.5", "libgauss_cl_jni.so"};
    private long m_handle = 0L;
    private PgConnection m_jdbcConn = null;

    private static String getLibPath() {
        String[] paths = System.getProperty("java.library.path").split(":");
        if (paths.length > 0) {
            return paths[0];
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean copyLibFromJar(String inPathName, String dstPathName, boolean isOverWrite) {
        try (InputStream in = ClientLogicImpl.class.getResourceAsStream(inPathName);){
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            File fileOut = new File(dstPathName);
            if (isOverWrite) {
                Files.copy(in, fileOut.getAbsoluteFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            try {
                Files.copy(in, fileOut.getAbsoluteFile().toPath(), new CopyOption[0]);
                return true;
            }
            catch (IOException ie) {
                boolean bl = false;
                if (in == null) return bl;
                if (var4_6 != null) {
                    try {
                        in.close();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        var4_6.addSuppressed(throwable);
                        return bl;
                    }
                }
                in.close();
                return bl;
            }
        }
        catch (IOException ie) {
            LOGGER.info("copy library failed!");
            return false;
        }
        catch (SecurityException se) {
            LOGGER.info("copy library failed! ", se);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean hasLibrary(String inPathName) {
        try (InputStream in = ClientLogicImpl.class.getResourceAsStream(inPathName);){
            if (in != null) return true;
            LOGGER.info("no lib in jar: no need to copy.");
            boolean bl = false;
            return bl;
        }
        catch (IOException ie) {
            LOGGER.info("get library from jar failed!", ie);
            return false;
        }
        catch (SecurityException se) {
            LOGGER.info("get library from jar failed", se);
            return false;
        }
    }

    private static void copyLibList() {
        String dstPath = ClientLogicImpl.getLibPath() + File.separator;
        String inPath = File.separator + "lib" + File.separator;
        if (File.separator.equals(dstPath)) {
            LOGGER.info("library path error!");
            return;
        }
        if (!ClientLogicImpl.hasLibrary(inPath + "libgauss_cl_jni.so")) {
            return;
        }
        boolean isOverWrite = !ClientLogicImpl.isVersionMatch(dstPath + "libVersion");
        for (String libname : LIB_LIST) {
            ClientLogicImpl.copyLibFromJar(inPath + libname, dstPath + libname, isOverWrite);
        }
        LOGGER.info("copy libraries end!");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readLibVersion(String versionFilePath) {
        try (FileReader reader = new FileReader(versionFilePath);){
            Properties properties = new Properties();
            properties.load(reader);
            String string = properties.getProperty("lib.version");
            return string;
        }
        catch (FileNotFoundException fe) {
            LOGGER.error("version file not found ", fe);
            return "";
        }
        catch (IOException ie) {
            LOGGER.error("properties load failed ", ie);
            return "";
        }
    }

    private static void writeLibVersion(String version, String versionFilePath) {
        try (FileWriter filewriter = new FileWriter(versionFilePath);){
            Properties properties = new Properties();
            properties.setProperty("lib.version", version);
            properties.store(filewriter, "new set");
            return;
        }
        catch (IOException ie) {
            LOGGER.error("write lib version failed ", ie);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readLibVersionFromJar() {
        String libVerFilePath = File.separator + "lib" + File.separator + "libVersionFile";
        try (InputStream in = ClientLogicImpl.class.getResourceAsStream(libVerFilePath);){
            if (in == null) {
                LOGGER.error("no lib version file in jar.");
                String string2 = "";
                return string2;
            }
            byte[] versionBytes = new byte[in.available()];
            int number = in.read(versionBytes);
            if (number == -1) {
                LOGGER.error("lib version file size error.");
            }
            String string = new String(versionBytes, "UTF8");
            return string;
        }
        catch (IOException ie) {
            LOGGER.info("get library from jar failed!", ie);
            return "";
        }
        catch (SecurityException se) {
            LOGGER.info("get library from jar failed", se);
            return "";
        }
    }

    private static boolean isVersionMatch(String versionFilePath) {
        String libVersion = ClientLogicImpl.readLibVersionFromJar();
        File versionFile = new File(versionFilePath);
        if (!versionFile.exists()) {
            try {
                if (!versionFile.createNewFile()) {
                    LOGGER.error("version file create failed.");
                    return false;
                }
            }
            catch (IOException ie) {
                LOGGER.error("version file create failed ", ie);
                return false;
            }
            ClientLogicImpl.writeLibVersion(libVersion, versionFilePath);
            return false;
        }
        if (!libVersion.equals(ClientLogicImpl.readLibVersion(versionFilePath))) {
            ClientLogicImpl.writeLibVersion(libVersion, versionFilePath);
            return false;
        }
        return true;
    }

    private native Object[] linkClientLogicImplExt(String var1, String var2);

    private native Object[] linkClientLogicImpl(String var1);

    private native Object[] setTokenToClientLogicImpl(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native Object[] fetchAndDeprocessColumnSettingImpl(long var1);

    private native Object[] setKmsInfoImpl(long var1, String var3, String var4);

    private native Object[] setCryptoModuleInfoImpl(long var1, String var3, String var4);

    private native Object[] runQueryPreProcessImpl(long var1, String var3);

    private native Object[] runQueryPostProcessImpl(long var1);

    private native Object[] runClientLogicImpl(long var1, byte[] var3, int var4);

    private native Object[] getRecordIDsImpl(long var1, String var3, int var4);

    private native Object[] runClientLogic4RecordImpl(long var1, String var3, int[] var4);

    private native Object[] prepareQueryImpl(long var1, String var3, String var4, int var5);

    private native Object[] replaceStatementParamsImpl(long var1, String var3, String[] var4);

    private native Object[] replaceErrorMessageImpl(long var1, String var3);

    private native int processedQueryPosToDeprocessedImpl(long var1, int var3);

    private native Object[] reloadCacheImpl(long var1);

    private native Object[] reloadCacheIfNeededImpl(long var1);

    private native void destroy(long var1);

    private native boolean getSortingAndAggregationPostRequired(long var1);

    private native int getSortingAndAggregationTargetLengthImpl(long var1);

    private native int getSortingAndAggregationOrderByLengthImpl(long var1);

    private native int getSortingAndAggregationGroupByLengthImpl(long var1);

    private native boolean getSortingAndAggregationDistinctImpl(long var1);

    private native TargetColumnMetaData getSortingAndAggregationTargetAtIndexImpl(long var1, int var3);

    private native SortColumnMetaData getSortingAndAggregationOrderByAtIndexImpl(long var1, int var3);

    private native SortColumnMetaData getSortingAndAggregationGroupByAtIndexImpl(long var1, int var3);

    private native LimitOffsetMetaData getSortingAndAggregationLimitOffsetImpl(long var1);

    private native void resetSortingAndAggregationImpl(long var1);

    private native String divideImpl(long var1, String var3, String var4);

    private native int deprocessDataImpl(long var1, String var3, long var4, String var6, String var7, String var8, String[] var9, String[] var10, long[] var11);

    public int getSortingAndAggregationTargetLength() {
        return this.getSortingAndAggregationTargetLengthImpl(this.m_handle);
    }

    public TargetColumnMetaData getSortingAndAggregationTargetAtIndex(int index) {
        return this.getSortingAndAggregationTargetAtIndexImpl(this.m_handle, index);
    }

    public int getSortingAndAggregationOrderByLength() {
        return this.getSortingAndAggregationOrderByLengthImpl(this.m_handle);
    }

    public SortColumnMetaData getSortingAndAggregationOrderByAtIndex(int index) {
        return this.getSortingAndAggregationOrderByAtIndexImpl(this.m_handle, index);
    }

    public int getSortingAndAggregationGroupByLength() {
        return this.getSortingAndAggregationGroupByLengthImpl(this.m_handle);
    }

    public SortColumnMetaData getSortingAndAggregationGroupByAtIndex(int index) {
        return this.getSortingAndAggregationGroupByAtIndexImpl(this.m_handle, index);
    }

    public LimitOffsetMetaData getSortingAndAggregationLimitOffset() {
        return this.getSortingAndAggregationLimitOffsetImpl(this.m_handle);
    }

    public boolean getSortingAndAggregationPostRequired() {
        return this.getSortingAndAggregationPostRequired(this.m_handle);
    }

    public boolean getSortingAndAggregationDistinct() {
        return this.getSortingAndAggregationDistinctImpl(this.m_handle);
    }

    public void resetSortingAndAggregation() {
        this.resetSortingAndAggregationImpl(this.m_handle);
    }

    public String divide(String nom, String denom) {
        return this.divideImpl(this.m_handle, nom, denom);
    }

    public ClientLogicDecryptResult decryptData(String processedData, long processedDataSize, String schemaname, String tablename, String colname) {
        if (schemaname == null || tablename == null || colname == null || (long)processedData.length() < processedDataSize) {
            return new ClientLogicDecryptResult("Invalid input for decryption.");
        }
        String[] type = new String[1];
        String[] plaintext = new String[1];
        long[] plaintextSize = new long[1];
        int ret_val = this.deprocessDataImpl(this.m_handle, processedData, processedDataSize, schemaname, tablename, colname, type, plaintext, plaintextSize);
        if (ret_val == 0) {
            this.reloadCache();
            ret_val = this.deprocessDataImpl(this.m_handle, processedData, processedDataSize, schemaname, tablename, colname, type, plaintext, plaintextSize);
        }
        if (ret_val == 0) {
            return new ClientLogicDecryptResult(plaintext[0]);
        }
        return new ClientLogicDecryptResult(type[0], plaintext[0], plaintextSize[0]);
    }

    public Object[] linkClientLogic(String databaseName, String pgClientLogic, PgConnection jdbcConn) {
        if (this.m_handle == 0L && this.m_jdbcConn == null) {
            this.m_jdbcConn = jdbcConn;
            return this.linkClientLogicImplExt(databaseName, pgClientLogic);
        }
        return new Object[0];
    }

    public Object[] fetchAndDecryptCek() {
        return this.fetchAndDeprocessColumnSettingImpl(this.m_handle);
    }

    public Object[] setKeyToClientLogic(byte[] rsaPubKey, int rsaPubKeyLen, byte[] ecdhKey, int ecdhKeyLen) {
        return this.setTokenToClientLogicImpl(this.m_handle, rsaPubKey, rsaPubKeyLen, ecdhKey, ecdhKeyLen);
    }

    public Object[] setKmsInfo(String key, String value) {
        return this.setKmsInfoImpl(this.m_handle, key, value);
    }

    public Object[] setCryptoModuleInfo(String key, String value) {
        return this.setCryptoModuleInfoImpl(this.m_handle, key, value);
    }

    public Object[] runQueryPreProcess(String originalQuery) {
        return this.runQueryPreProcessImpl(this.m_handle, originalQuery);
    }

    public Object[] runClientLogic(byte[] data2Process, int dataType) {
        return this.runClientLogicImpl(this.m_handle, data2Process, dataType);
    }

    public Object[] getRecordIDs(String dataTypeName, int oid) {
        return this.getRecordIDsImpl(this.m_handle, dataTypeName, oid);
    }

    public Object[] runClientLogic4Record(String data2Process, int[] originalOids) {
        return this.runClientLogic4RecordImpl(this.m_handle, data2Process, originalOids);
    }

    public Object[] runQueryPostProcess() {
        return this.runQueryPostProcessImpl(this.m_handle);
    }

    public Object[] prepareQuery(String query, String statement_name, int parameter_count) {
        return this.prepareQueryImpl(this.m_handle, query, statement_name, parameter_count);
    }

    public Object[] replaceStatementParams(String statementName, String[] paramValues) {
        return this.replaceStatementParamsImpl(this.m_handle, statementName, paramValues);
    }

    public Object[] replaceErrorMessage(String originalMessage) {
        return this.replaceErrorMessageImpl(this.m_handle, originalMessage);
    }

    public int processedQueryPosToDeprocessed(int processedPos) {
        return this.processedQueryPosToDeprocessedImpl(this.m_handle, processedPos);
    }

    protected void close() {
        if (this.m_handle > 0L) {
            this.destroy(this.m_handle);
        }
        this.m_handle = 0L;
    }

    protected void finalize() {
        this.close();
    }

    public void setHandle(long handle) {
        this.m_handle = handle;
    }

    public long getHandle() {
        return this.m_handle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] fetchDataFromQuery(String query) {
        PgStatement st = null;
        ArrayList<Object> data = new ArrayList<Object>();
        data.add("");
        try {
            st = (PgStatement)this.m_jdbcConn.createStatement();
            ResultSet rs = st.executeQueryWithNoCL(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnsCount = rsmd.getColumnCount();
            ArrayList<String> headers = new ArrayList<String>();
            for (int colIndex = 0; colIndex < columnsCount; ++colIndex) {
                headers.add(rsmd.getColumnName(colIndex + 1));
            }
            data.add(headers.toArray());
            while (rs.next()) {
                ArrayList<String> record = new ArrayList<String>();
                for (int colIndex = 1; colIndex < columnsCount + 1; ++colIndex) {
                    String colValue = rs.getString(colIndex);
                    if (colValue == null) {
                        colValue = "";
                    }
                    record.add(colValue);
                }
                data.add(record.toArray());
            }
            st.close();
        }
        catch (SQLException e) {
            Object[] objectArray;
            try {
                ArrayList<String> errorResponse = new ArrayList<String>();
                errorResponse.add(e.getMessage());
                objectArray = errorResponse.toArray();
            }
            catch (Throwable throwable) {
                JdbcBlackHole.close(st);
                throw throwable;
            }
            JdbcBlackHole.close(st);
            return objectArray;
        }
        JdbcBlackHole.close(st);
        return data.toArray();
    }

    public Object[] reloadCache() {
        return this.reloadCacheImpl(this.m_handle);
    }

    public Object[] reloadCacheIfNeeded() {
        return this.reloadCacheIfNeededImpl(this.m_handle);
    }

    static {
        ClientLogicImpl.copyLibList();
        try {
            System.loadLibrary("gauss_cl_jni");
        }
        catch (UnsatisfiedLinkError ue) {
            LOGGER.warn("load library failed", ue);
        }
    }
}

