/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.util;

import com.huawei.gaussdb.jdbc.PGConnection;
import com.huawei.gaussdb.jdbc.core.QueryExecutor;
import com.huawei.gaussdb.jdbc.core.SetupQueryRunner;
import com.huawei.gaussdb.jdbc.jdbc.alt.reset.AdvisoryLock;
import com.huawei.gaussdb.jdbc.jdbc.alt.reset.GucParam;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;

public class TacReConnectUtil {
    private static Log LOGGER = Logger.getLogger(TacReConnectUtil.class.getName());
    private static final String QUERY_GUC_PARAM = "select name,setting,vartype from pg_settings where context = 'user' and source = 'session'";
    private static final String QUERY_ADVISORY_LOCK = "select sessionid, classid, objid, mode from pg_locks where locktype='advisory'";

    public static List<GucParam> queryGUCParams(PGConnection pgConnection) {
        try {
            List<byte[][]> gucParams = SetupQueryRunner.runForList(pgConnection.tacGetQueryExecutor(), QUERY_GUC_PARAM, true);
            QueryExecutor executor = pgConnection.tacGetQueryExecutor();
            return TacReConnectUtil.transToGucParams(gucParams, executor);
        }
        catch (SQLException se) {
            return new ArrayList<GucParam>();
        }
    }

    public static List<AdvisoryLock> queryAdvisoryLock(PGConnection pgConnection) {
        try {
            List<byte[][]> advisoryLocks = SetupQueryRunner.runForList(pgConnection.tacGetQueryExecutor(), QUERY_ADVISORY_LOCK, true);
            QueryExecutor executor = pgConnection.tacGetQueryExecutor();
            return TacReConnectUtil.transToAdvisoryLock(advisoryLocks, executor);
        }
        catch (SQLException set) {
            return new ArrayList<AdvisoryLock>();
        }
    }

    public static void resetAndUnlockCons(List<PGConnection> pgConnections) {
        if (pgConnections == null) {
            return;
        }
        LoggerUtil.debug(LOGGER, "Begin unlock cons, the size of ConnectInfo is " + pgConnections.size());
        for (PGConnection pgConnection : pgConnections) {
            if (pgConnection == null || !pgConnection.hasLock()) continue;
            pgConnection.resetStatement();
            pgConnection.unlock();
        }
        LoggerUtil.debug(LOGGER, "CN/DN unlock completed");
    }

    private static List<GucParam> transToGucParams(List<byte[][]> gucParams, QueryExecutor queryExecutor) {
        if (gucParams == null || queryExecutor == null) {
            return new ArrayList<GucParam>();
        }
        ArrayList<GucParam> result = new ArrayList<GucParam>();
        for (byte[][] gucParam : gucParams) {
            try {
                ArrayDeque<byte[]> params = TacReConnectUtil.transByteArrayToQueue(gucParam);
                String name = queryExecutor.getEncoding().decode(params.pollFirst());
                String setting = queryExecutor.getEncoding().decode(params.pollFirst());
                String varType = queryExecutor.getEncoding().decode(params.pollFirst());
                result.add(new GucParam(name, setting, varType));
            }
            catch (IOException e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("can't encode guc param");
            }
        }
        return result;
    }

    private static List<AdvisoryLock> transToAdvisoryLock(List<byte[][]> advisoryLocks, QueryExecutor queryExecutor) {
        if (advisoryLocks == null || queryExecutor == null) {
            return new ArrayList<AdvisoryLock>();
        }
        ArrayList<AdvisoryLock> result = new ArrayList<AdvisoryLock>();
        for (byte[][] advisoryLock : advisoryLocks) {
            try {
                ArrayDeque<byte[]> locks = TacReConnectUtil.transByteArrayToQueue(advisoryLock);
                String sessionId = queryExecutor.getEncoding().decode(locks.pollFirst());
                String classId = queryExecutor.getEncoding().decode(locks.pollFirst());
                String objId = queryExecutor.getEncoding().decode(locks.pollFirst());
                String mode = queryExecutor.getEncoding().decode(locks.pollFirst());
                result.add(new AdvisoryLock(sessionId, classId, objId, mode));
            }
            catch (IOException e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn("can't encode advisory lock");
            }
        }
        return result;
    }

    private static ArrayDeque<byte[]> transByteArrayToQueue(byte[][] advisoryLock) {
        ArrayDeque<byte[]> arrayDeque = new ArrayDeque<byte[]>();
        for (byte[] byteArray : advisoryLock) {
            arrayDeque.add(byteArray == null ? new byte[]{} : byteArray);
        }
        return arrayDeque;
    }
}

