/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.tac;

import com.huawei.gaussdb.jdbc.PGConnection;
import com.huawei.gaussdb.jdbc.jdbc.alt.batch.TacBatchExecution;
import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTContext;
import com.huawei.gaussdb.jdbc.jdbc.alt.exception.ALTException;
import com.huawei.gaussdb.jdbc.jdbc.alt.tac.TacReConnectInfo;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.LoggerUtil;
import com.huawei.gaussdb.jdbc.jdbc.alt.util.TacReConnectUtil;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class TacReConnectActuator {
    private static final Log LOGGER = Logger.getLogger(TacReConnectActuator.class.getName());
    private static final long RECONNECT_DN_TIMEOUT = TimeUnit.MINUTES.toMillis(2L);
    private final String altClusterId;
    private final List<TacReConnectInfo> tacReConnectInfoList;
    private final ALTContext context;

    public TacReConnectActuator(ALTContext context, String altClusterId, List<TacReConnectInfo> tacReConnectInfoList) {
        this.tacReConnectInfoList = tacReConnectInfoList;
        this.altClusterId = altClusterId;
        this.context = context;
    }

    public String getAltClusterId() {
        return this.altClusterId;
    }

    public void reConnect() {
        this.reconnectToDN();
        this.unlockPgConn();
    }

    private void reconnectToDN() {
        LoggerUtil.debug(LOGGER, "Begin reconnect to DN, the size of DN is " + this.tacReConnectInfoList.size());
        TacBatchExecution<TacReConnectInfo, Boolean> tacBatchExecution = new TacBatchExecution<TacReConnectInfo, Boolean>(this.tacReConnectInfoList, this.context.buildReconnectFunction());
        try {
            tacBatchExecution.execute(RECONNECT_DN_TIMEOUT);
        }
        catch (ALTException e) {
            LoggerUtil.warn(LOGGER, e.getMessage());
        }
        LoggerUtil.debug(LOGGER, "DN reconnection completed");
    }

    public void unlockPgConn() {
        if (this.tacReConnectInfoList == null || this.tacReConnectInfoList.isEmpty()) {
            return;
        }
        ArrayList<PGConnection> pgConnections = new ArrayList<PGConnection>();
        for (TacReConnectInfo tacReConnectInfo : this.tacReConnectInfoList) {
            PGConnection con = tacReConnectInfo.getPgConnection();
            if (con == null) continue;
            pgConnections.add(con);
        }
        TacReConnectUtil.resetAndUnlockCons(pgConnections);
    }

    public String toString() {
        return "TacReConnectActuator{altClusterId='" + this.altClusterId + '\'' + ", tacReConnectInfoListSize=" + this.tacReConnectInfoList.size() + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TacReConnectActuator)) {
            return false;
        }
        TacReConnectActuator that = (TacReConnectActuator)o;
        return Objects.equals(this.altClusterId, that.altClusterId) && Objects.equals(this.tacReConnectInfoList, that.tacReConnectInfoList);
    }

    public int hashCode() {
        return Objects.hash(this.altClusterId, this.tacReConnectInfoList);
    }
}

