/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.tac;

import com.huawei.gaussdb.jdbc.jdbc.ResourceLock;
import com.huawei.gaussdb.jdbc.jdbc.alt.exception.ALTException;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TacLock {
    private static final long DEFAULT_WAIT_TIME = 120000L;
    private final Lock reentrantLock = new ReentrantLock();
    private final Condition condition = this.reentrantLock.newCondition();
    private final Lock connectLock = new ResourceLock();
    private volatile boolean isLock = false;

    public boolean waitOnLock(long timeMillis) {
        try {
            return this.waitForResult(timeMillis);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForResult(long timeMillis) throws InterruptedException {
        if (!this.reentrantLock.tryLock(timeMillis, TimeUnit.MILLISECONDS)) {
            return false;
        }
        try {
            long nanos = TimeUnit.MILLISECONDS.toNanos(timeMillis);
            while (this.isLock) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.condition.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    public boolean waitOnLock() {
        return this.waitOnLock(120000L);
    }

    public void unlock() throws ALTException {
        if (!this.isLock) {
            return;
        }
        try {
            if (!this.reentrantLock.tryLock(120000L, TimeUnit.MILLISECONDS)) {
                throw new ALTException("timeout when acquire lock, isLock is " + this.isLock);
            }
            try {
                this.isLock = false;
                this.condition.signalAll();
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
        catch (InterruptedException e) {
            throw new ALTException("interrupted when unlock, isLock is " + this.isLock, e.getCause());
        }
    }

    public void lock() {
        this.isLock = true;
    }

    public boolean hasLock() {
        return this.isLock;
    }

    public Lock getConnectLock() {
        return this.connectLock;
    }

    public String toString() {
        return "TacLock{isLock=" + this.isLock + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TacLock)) {
            return false;
        }
        return false;
    }

    public synchronized int hashCode() {
        return Objects.hash(this.isLock);
    }
}

