/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc.alt.batch;

import com.huawei.gaussdb.jdbc.jdbc.alt.batch.Function;
import com.huawei.gaussdb.jdbc.jdbc.alt.batch.TacBatchTask;
import com.huawei.gaussdb.jdbc.jdbc.alt.cluster.ALTThreadPool;
import com.huawei.gaussdb.jdbc.jdbc.alt.exception.ALTException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TacBatchExecution<E, T> {
    private static final int DEFAULT_SINGLE_NUM = 10;
    private final List<E> pgConnections;
    private final int singleNum;
    private final Function<E, T> function;

    public TacBatchExecution(List<E> pgConnections, Function<E, T> function) {
        this(pgConnections, 10, function);
    }

    private TacBatchExecution(List<E> pgConnections, int singleNum, Function<E, T> function) {
        this.pgConnections = pgConnections;
        this.singleNum = singleNum;
        this.function = function;
    }

    public List<T> execute(long timeout) throws ALTException {
        List<List<E>> pgArrayList = this.split(this.pgConnections, this.singleNum);
        CountDownLatch latch = new CountDownLatch(pgArrayList.size());
        ArrayList<TacBatchTask<E, T>> tasks = new ArrayList<TacBatchTask<E, T>>(pgArrayList.size());
        for (List<E> connections : pgArrayList) {
            TacBatchTask<E, T> tacBatchTask = new TacBatchTask<E, T>(connections, this.function, latch);
            tasks.add(tacBatchTask);
            this.executeTask(tacBatchTask);
        }
        try {
            boolean isCountDownBeforeTimeout = latch.await(timeout, TimeUnit.MILLISECONDS);
            if (!isCountDownBeforeTimeout) {
                throw new ALTException("timeout when execute task, the size of task is :" + this.pgConnections.size());
            }
        }
        catch (InterruptedException e) {
            throw new ALTException("interrupt when execute task, the size of task is :" + this.pgConnections.size(), e.getCause());
        }
        ArrayList results = new ArrayList();
        for (TacBatchTask tacBatchTask : tasks) {
            results.addAll(tacBatchTask.getResults());
        }
        return results;
    }

    private List<List<E>> split(List<E> elements, int num) {
        ArrayList<List<List<E>>> results = new ArrayList<List<List<E>>>(elements.size() / num + 1);
        int size = elements.size();
        for (int index = 0; index < size; index += num) {
            results.add(elements.subList(index, Math.min(index + num, elements.size())));
        }
        return results;
    }

    private void executeTask(Runnable runnable) {
        ALTThreadPool altThreadPool = ALTThreadPool.getInstance();
        altThreadPool.executeTask(runnable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TacBatchExecution that = (TacBatchExecution)o;
        return this.singleNum == that.singleNum && Objects.equals(this.pgConnections, that.pgConnections) && Objects.equals(this.function, that.function);
    }

    public int hashCode() {
        return Objects.hash(this.pgConnections, this.singleNum, this.function);
    }

    public String toString() {
        return "TacBatchExecution{pgConnections=" + this.pgConnections + ", singleNum=" + this.singleNum + ", function=" + this.function + '}';
    }
}

