/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.jdbc;

import com.huawei.gaussdb.jdbc.core.CachedQuery;
import com.huawei.gaussdb.jdbc.jdbc.PgConnection;
import com.huawei.gaussdb.jdbc.jdbc.PgPreparedStatement;
import com.huawei.gaussdb.jdbc.mysqlcompatibility.MBooleanTypeUtils;
import com.huawei.gaussdb.jdbc.util.GT;
import com.huawei.gaussdb.jdbc.util.PSQLException;
import com.huawei.gaussdb.jdbc.util.PSQLState;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;

class MPreparedStatement
extends PgPreparedStatement {
    MPreparedStatement(PgConnection connection, String sql, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, sql, rsType, rsConcurrency, rsHoldability);
    }

    MPreparedStatement(PgConnection connection, CachedQuery query, int rsType, int rsConcurrency, int rsHoldability) throws SQLException {
        super(connection, query, rsType, rsConcurrency, rsHoldability);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkClosed();
        this.preparedParameters.setNull(parameterIndex, 0);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.checkClosed();
        this.preparedParameters.setNull(parameterIndex, 0);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkClosed();
        if (x == null) {
            this.setNull(parameterIndex, -3);
            return;
        }
        byte[] copyData = new byte[x.length];
        System.arraycopy(x, 0, copyData, 0, x.length);
        this.preparedParameters.setBytesForM(parameterIndex, copyData, 0, x.length);
        String clientLogicValue = "\\x" + MPreparedStatement.bytesArrayToHexString(x);
        this.preparedParameters.saveLiteralValueForClientLogic(parameterIndex, clientLogicValue);
    }

    @Override
    public void setDate(int i, java.sql.Date date, Calendar calendar) throws SQLException {
        this.checkClosed();
        if (date == null) {
            this.setNull(i, 91);
            return;
        }
        if (calendar == null) {
            this.bindString(i, this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), date, false), 0);
            return;
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(calendar, date, false), 0);
    }

    @Override
    public void setTime(int i, Time time, Calendar cal) throws SQLException {
        this.checkClosed();
        if (time == null) {
            this.setNull(i, 92);
            return;
        }
        if (cal == null) {
            this.bindString(i, this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), time, false), 0);
            return;
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, time, false), 0);
    }

    @Override
    public void setTimestamp(int i, Timestamp timestamp, Calendar cal) throws SQLException {
        this.checkClosed();
        if (timestamp == null) {
            this.setNull(i, 93);
            return;
        }
        if (cal == null) {
            this.bindString(i, this.connection.getTimestampUtils().toString(this.getDefaultCalendar(), timestamp, false), 0);
            return;
        }
        this.bindString(i, this.connection.getTimestampUtils().toString(cal, timestamp, false), 0);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean isTrue) throws SQLException {
        this.checkClosed();
        this.bindString(parameterIndex, isTrue ? "1" : "0", 5545);
    }

    @Override
    protected void setBooleanInternal(int parameterIndex, Object in) throws SQLException {
        this.setBoolean(parameterIndex, MBooleanTypeUtils.castToBoolean(in));
    }

    @Override
    protected void setBlobInternal(int parameterIndex, Object in) throws SQLException {
        if (in instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)in);
        } else if (in instanceof InputStream) {
            long oid = this.createBlob(parameterIndex, (InputStream)in, -1L);
            this.setLong(parameterIndex, oid);
        } else if (in instanceof String) {
            this.setString(parameterIndex, (String)in);
        } else {
            throw new PSQLException(GT.tr("Cannot cast an instance of {0} to type {1}", in.getClass().getName(), "Types.BLOB"), PSQLState.INVALID_PARAMETER_TYPE);
        }
    }

    @Override
    protected void setTimeInternal(int parameterIndex, Object in) throws SQLException {
        if (in instanceof Time) {
            this.setTime(parameterIndex, (Time)in);
        } else if (in instanceof LocalTime) {
            this.bindString(parameterIndex, this.connection.getTimestampUtils().toString((LocalTime)in), 1083);
        } else if (in instanceof String) {
            this.setString(parameterIndex, (String)in);
        } else if (in instanceof Date) {
            this.setTime(parameterIndex, new Time(((Date)in).getTime()));
        } else {
            this.setTime(parameterIndex, this.connection.getTimestampUtils().toTime(this.getDefaultCalendar(), in.toString()));
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkClosed();
        this.setString(parameterIndex, x, 1043);
    }

    @Override
    public void setBlob(int i, Blob blob) throws SQLException {
        this.checkClosed();
        if (blob == null) {
            this.setNull(i, 2004);
            return;
        }
        byte[] bytes = blob.getBytes(1L, (int)blob.length());
        byte[] bytesCopy = new byte[bytes.length];
        System.arraycopy(bytes, 0, bytesCopy, 0, bytes.length);
        this.preparedParameters.setBlobForM(i, bytesCopy, 0, bytes.length);
    }

    @Override
    public void setBlob(int i, InputStream in) throws SQLException {
        this.checkClosed();
        if (in == null) {
            this.setNull(i, 2004);
            return;
        }
        this.preparedParameters.setBlobForM(i, in);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream is, long length) throws SQLException {
        this.checkClosed();
        if (is == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (length > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("Object is too large to send over the protocol. {0}", length), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        if (length < 0L) {
            throw new PSQLException(GT.tr("INVALID_STREAM_LENGTH", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBlobForM(parameterIndex, is, (int)length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream is) throws SQLException {
        this.checkClosed();
        if (is == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        this.preparedParameters.setBlobForM(parameterIndex, is);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream is, int length) throws SQLException {
        this.checkClosed();
        if (is == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (length < 0) {
            throw new PSQLException(GT.tr("INVALID_STREAM_LENGTH", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBlobForM(parameterIndex, is, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream is, long length) throws SQLException {
        this.checkClosed();
        if (is == null) {
            this.setNull(parameterIndex, 2004);
            return;
        }
        if (length > Integer.MAX_VALUE) {
            throw new PSQLException(GT.tr("Object is too large to send over the protocol.", new Object[0]), PSQLState.NUMERIC_CONSTANT_OUT_OF_RANGE);
        }
        if (length < 0L) {
            throw new PSQLException(GT.tr("INVALID_STREAM_LENGTH", length), PSQLState.INVALID_PARAMETER_VALUE);
        }
        this.preparedParameters.setBlobForM(parameterIndex, is, (int)length);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        super.setFloat(parameterIndex, x);
    }

    @Override
    void setFloatInternal(int parameterIndex, float x) throws SQLException {
        this.bindLiteral(parameterIndex, Float.toString(x), 700);
    }
}

