/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.core;

import com.huawei.gaussdb.jdbc.CollectDBData;
import com.huawei.gaussdb.jdbc.GlobalConnectionTracker;
import com.huawei.gaussdb.jdbc.core.PGStream;
import com.huawei.gaussdb.jdbc.core.QueryExecutor;
import com.huawei.gaussdb.jdbc.core.QueryExecutorBase;
import com.huawei.gaussdb.jdbc.jdbc.alt.fan.DBConnectionTracker;
import com.huawei.gaussdb.jdbc.log.Log;
import com.huawei.gaussdb.jdbc.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class QueryExecutorCloseAction
implements Closeable {
    private static final Log LOGGER = Logger.getLogger(QueryExecutorBase.class.getName());
    private static final AtomicReferenceFieldUpdater<QueryExecutorCloseAction, PGStream> PG_STREAM_UPDATER = AtomicReferenceFieldUpdater.newUpdater(QueryExecutorCloseAction.class, PGStream.class, "pgStream");
    private QueryExecutor queryExecutor;
    private Properties props;
    private volatile PGStream pgStream;

    public QueryExecutorCloseAction(PGStream pgStream, QueryExecutor queryExecutor, Properties props) {
        this.pgStream = pgStream;
        this.queryExecutor = queryExecutor;
        this.props = props;
    }

    public boolean isClosed() {
        PGStream stream = this.pgStream;
        return stream == null || stream.isClosed();
    }

    public void abort() {
        PGStream stream = this.pgStream;
        if (stream == null || !PG_STREAM_UPDATER.compareAndSet(this, stream, null)) {
            return;
        }
        try {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace(" FE=> close socket");
            }
            stream.getSocket().close();
            CollectDBData.increaseCount(this.props, CollectDBData.CollectType.ABORT);
        }
        catch (IOException e) {
            LOGGER.trace("Catch IOException on close:", e);
        }
    }

    @Override
    public void close() throws IOException {
        PGStream stream;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(" FE=> Terminate");
        }
        if ((stream = this.pgStream) == null || !PG_STREAM_UPDATER.compareAndSet(this, stream, null)) {
            return;
        }
        this.sendCloseMessage(stream);
        if (stream.isClosed()) {
            return;
        }
        stream.flush();
        stream.close();
        GlobalConnectionTracker.releaseConnectionReference(this.queryExecutor, this.props);
        CollectDBData.increaseCount(this.props, CollectDBData.CollectType.CLOSE);
        if (DBConnectionTracker.enableFan(this.props)) {
            DBConnectionTracker.getInstance().releaseFanDbConnection(this.queryExecutor, this.props);
        }
    }

    public void sendCloseMessage(PGStream pgStream) throws IOException {
        if (pgStream.isClosed()) {
            return;
        }
        int timeout = pgStream.getNetworkTimeout();
        if (timeout == 0 || timeout > 1000) {
            pgStream.setNetworkTimeout(1000);
        }
        pgStream.sendChar(88);
        pgStream.sendInteger4(4);
    }

    public String toString() {
        return "QueryExecutorCloseAction{queryExecutor=" + this.queryExecutor + ", props=" + this.props + ", pgStream=" + this.pgStream + '}';
    }
}

