/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.gaussdb.jdbc.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public class ZHS16GBKHandler {
    public static final char UNMAPPABLE_DECODING = '\ufffd';
    public static final int UNMAPPABLE_ENCODING = 65533;
    static final char[] B2C_UNMAPPABLE = new char[256];

    static {
        Arrays.fill(B2C_UNMAPPABLE, '\ufffd');
    }

    public static class Encoder
    extends CharsetEncoder {
        public static final int MAX_SINGLE_BYTE = 255;
        private final char[] c2b;
        private final char[] c2bIndex;

        Encoder(Charset cs, char[] c2b, char[] c2bIndex) {
            super(cs, 2.0f, 2.0f);
            this.c2b = c2b;
            this.c2bIndex = c2bIndex;
        }

        static void initC2B(String[] b2c, String b2cSB, char[] c2b, char[] c2bIndex) {
            Arrays.fill(c2b, '\ufffd');
            char[][] b2cCa = new char[b2c.length][];
            char[] b2cSBCa = null;
            if (b2cSB != null) {
                b2cSBCa = b2cSB.toCharArray();
            }
            for (int i = 0; i < b2c.length; ++i) {
                if (b2c[i] == null) continue;
                b2cCa[i] = b2c[i].toCharArray();
            }
            int off = 256;
            if (b2cSBCa != null) {
                off = Encoder.handleSingleByte(c2b, c2bIndex, b2cSBCa, off);
            }
            for (int b1 = 0; b1 < b2c.length; ++b1) {
                char[] db = b2cCa[b1];
                if (db == null) continue;
                off = Encoder.handleDoubleByte(c2b, c2bIndex, off, b1, db);
            }
        }

        private static int handleSingleByte(char[] c2b, char[] c2bIndex, char[] b2cSBCa, int offset) {
            int off = offset;
            for (int b = 0; b < b2cSBCa.length; ++b) {
                char c = b2cSBCa[b];
                if (c == '\ufffd') continue;
                int index = c2bIndex[c >> 8];
                if (index == 0) {
                    index = off;
                    off += 256;
                    c2bIndex[c >> 8] = (char)index;
                }
                c2b[index + (c & 0xFF)] = (char)b;
            }
            return off;
        }

        private static int handleDoubleByte(char[] c2b, char[] c2bIndex, int offset, int b1, char[] db) {
            int b2Min = 64;
            int b2Max = 254;
            int off = offset;
            for (int b2 = b2Min; b2 <= b2Max; ++b2) {
                char c = db[b2 - b2Min];
                if (c == '\ufffd') continue;
                int index = c2bIndex[c >> 8];
                if (index == 0) {
                    index = off;
                    off += 256;
                    c2bIndex[c >> 8] = (char)index;
                }
                c2b[index + (c & 0xFF)] = (char)(b1 << 8 | b2);
            }
            return off;
        }

        @Override
        public boolean canEncode(char c) {
            return this.encodeChar(c) != 65533;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            int sp;
            char[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                for (sp = src.arrayOffset() + src.position(); sp < sl; ++sp) {
                    char c = sa[sp];
                    int bb = this.encodeChar(c);
                    if (bb == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (bb > 255) {
                        if (dl - dp < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)(bb >> 8);
                        da[dp++] = (byte)bb;
                        continue;
                    }
                    if (dl - dp < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = (byte)bb;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char c = src.get();
                    int bb = this.encodeChar(c);
                    if (bb == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (dst.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    dst.put((byte)bb);
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        public int encodeChar(char ch) {
            return this.c2b[this.c2bIndex[ch >> 8] + (ch & 0xFF)];
        }
    }

    public static class Decoder
    extends CharsetDecoder {
        final char[][] b2c;
        final char[] b2cSB;
        final int b2Min;
        final int b2Max;

        Decoder(Charset cs, char[][] b2c, char[] b2cSB, int b2Min, int b2Max) {
            super(cs, 0.5f, 1.0f);
            this.b2c = b2c;
            this.b2cSB = b2cSB;
            this.b2Min = b2Min;
            this.b2Max = b2Max;
        }

        protected CoderResult crMalformedOrUnmappable(int b1, int b2) {
            if (this.b2c[b1] == B2C_UNMAPPABLE || this.b2c[b2] != B2C_UNMAPPABLE || this.decodeSingle(b2) != '\ufffd') {
                return CoderResult.malformedForLength(1);
            }
            return CoderResult.unmappableForLength(2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            int sp;
            byte[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                int inSize;
                for (sp = src.arrayOffset() + src.position(); sp < sl && dp < dl; sp += inSize) {
                    inSize = 1;
                    int b1 = sa[sp] & 0xFF;
                    char c = this.b2cSB[b1];
                    if (c == '\ufffd') {
                        if (sl - sp < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int b2 = sa[sp + 1] & 0xFF;
                        if (b2 < this.b2Min || b2 > this.b2Max || (c = this.b2c[b1][b2 - this.b2Min]) == '\ufffd') {
                            CoderResult coderResult = this.crMalformedOrUnmappable(b1, b2);
                            return coderResult;
                        }
                        ++inSize;
                    }
                    da[dp++] = c;
                }
                CoderResult coderResult = sp >= sl ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining() && dst.hasRemaining()) {
                    int b1 = src.get() & 0xFF;
                    char c = this.b2cSB[b1];
                    int inSize = 1;
                    if (c == '\ufffd') {
                        if (src.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int b2 = src.get() & 0xFF;
                        if (b2 < this.b2Min || b2 > this.b2Max || (c = this.b2c[b1][b2 - this.b2Min]) == '\ufffd') {
                            CoderResult coderResult = this.crMalformedOrUnmappable(b1, b2);
                            return coderResult;
                        }
                        ++inSize;
                    }
                    dst.put(c);
                    mark += inSize;
                }
                CoderResult coderResult = src.hasRemaining() ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        @Override
        public void implReset() {
            super.implReset();
        }

        @Override
        public CoderResult implFlush(CharBuffer out) {
            return super.implFlush(out);
        }

        public char decodeSingle(int b) {
            return this.b2cSB[b];
        }

        public char decodeDouble(int b1, int b2) {
            if (b1 < 0 || b1 > this.b2c.length || b2 < this.b2Min || b2 > this.b2Max) {
                return '\ufffd';
            }
            return this.b2c[b1][b2 - this.b2Min];
        }
    }
}

