/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.collector.thread;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.utils.ParameterParseUtil;
import com.lubanops.apm.plugin.collector.thread.JVMThreadDetailAggregator;
import java.util.Map;

public class JVMThreadCollector
extends Collector {
    private static final int DEFAULT_THREAD_INFO_DEPTH = 10;
    private static final int THREAD_INFO_DEPTH_UP_LIMIT = 51;
    private static final int THREAD_INFO_DEPTH_LOWER_LIMIT = 1;
    public static final JVMThreadCollector INSTANCE = new JVMThreadCollector();
    private static final JVMThreadDetailAggregator JVM_THREAD_DETAIL_AGGREGATOR = new JVMThreadDetailAggregator();
    private static int maxDepth = 10;

    public static JVMThreadCollector getInstance() {
        return INSTANCE;
    }

    public String getCollectorName() {
        return "Thread";
    }

    public void parseParameter(Map<String, String> parameters) {
        Integer newMaxDepth;
        if (parameters != null && (newMaxDepth = (Integer)ParameterParseUtil.getParameterValue(parameters, (String)"maxThreadDepth", Integer.class)) != null && newMaxDepth > 1 && newMaxDepth < 51) {
            maxDepth = newMaxDepth;
        }
    }

    public static int getMaxDepth() {
        return maxDepth;
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)JVM_THREAD_DETAIL_AGGREGATOR);
        INSTANCE.register();
    }
}

