/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.functiongraph.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.functiongraph.collector.ClusterAggregator;
import com.lubanops.apm.plugin.functiongraph.collector.ServerAggregator;
import java.util.Map;

public class FunctiongraphCollector
extends Collector {
    public static final FunctiongraphCollector INSTANCE = new FunctiongraphCollector();
    private static ThreadLocal<Boolean> hasErrorThreadlocal = new ThreadLocal();
    static ServerAggregator serverAggregator = new ServerAggregator();
    static ClusterAggregator clusterAggregator = new ClusterAggregator();

    public void parseParameter(Map<String, String> parameters) {
    }

    public static void onStart(String method, String envId) {
        String clusterId = "user";
        if (!StringUtils.isBlank((String)envId)) {
            clusterId = envId;
        }
        serverAggregator.onStart(method);
        clusterAggregator.onStart(clusterId);
    }

    public static void onError() {
        hasErrorThreadlocal.set(true);
        serverAggregator.onError();
    }

    public static void onFinally() {
        Long timeUsed = serverAggregator.onFinally();
        boolean hasError = false;
        if (hasErrorThreadlocal.get() != null) {
            hasError = true;
            hasErrorThreadlocal.set(null);
        }
        clusterAggregator.onFinally(timeUsed, hasError);
    }

    public String getCollectorName() {
        return "Functiongraph";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)serverAggregator);
        INSTANCE.addModelAggregator((MetricSetAggregator)clusterAggregator);
        INSTANCE.register();
    }
}

