/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.huawei.bsp.encrypt.cbb;

import com.lubanops.huawei.bsp.encrypt.cbb.CipherException;
import com.lubanops.huawei.bsp.encrypt.cbb.KeyType;
import com.lubanops.huawei.bsp.encrypt.cbb.impl.CipherManager1;
import java.io.File;

public abstract class CipherManager {
    public static final String ROOT_KEY = "root";

    public static CipherManager getInstance() throws CipherException {
        return CipherManager.getInstance(0);
    }

    public static CipherManager getInstance(int version) throws CipherException {
        switch (version) {
            case 0: 
            case 1: {
                return new CipherManager1();
            }
        }
        throw new CipherException("Unsupported version : " + version);
    }

    public abstract byte[] encodePasswordByte(char[] var1) throws CipherException;

    public abstract boolean matchPasswordByte(byte[] var1, char[] var2) throws CipherException;

    public abstract char[] encodePasswordChar(char[] var1) throws CipherException;

    public abstract boolean matchPasswordChar(char[] var1, char[] var2) throws CipherException;

    public abstract byte[] encrypt(byte[] var1, KeyType var2, String var3) throws CipherException;

    public abstract byte[] encrypt(byte[] var1, File var2) throws CipherException;

    public abstract byte[] encrypt(byte[] var1, File var2, File var3) throws CipherException;

    public abstract char[] encrypt(char[] var1, KeyType var2, String var3) throws CipherException;

    public abstract char[] encrypt(char[] var1, File var2) throws CipherException;

    public abstract char[] encrypt(char[] var1, File var2, File var3) throws CipherException;

    public abstract byte[] decrypt(byte[] var1, KeyType var2, String var3) throws CipherException;

    public abstract byte[] decrypt(byte[] var1, File var2) throws CipherException;

    public abstract byte[] decrypt(byte[] var1, File var2, File var3) throws CipherException;

    public abstract char[] decrypt(char[] var1, KeyType var2, String var3) throws CipherException;

    public abstract char[] decrypt(char[] var1, File var2) throws CipherException;

    public abstract char[] decrypt(char[] var1, File var2, File var3) throws CipherException;
}

