/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.profiler;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.apm.APMCollector;
import com.lubanops.apm.bootstrap.profiler.ProfilerReportService;
import com.lubanops.apm.core.transfer.InvokerService;
import com.lubanops.apm.core.transfer.TransferInvokerService;
import com.lubanops.apm.core.utils.ReportDataBuilder;
import com.lubanops.apm.integration.access.MessageIdGenerator;
import com.lubanops.apm.integration.access.MessageWrapper;
import com.lubanops.apm.integration.access.inbound.ProfileMessage;

public class ProfilerReportServiceImpl
implements ProfilerReportService {
    private static final Logger LOGGER = LogFactory.getLogger();
    private InvokerService invokerService = TransferInvokerService.getInstance();
    private boolean hasException = Boolean.FALSE;
    private static volatile ProfilerReportServiceImpl instance;

    public static synchronized ProfilerReportServiceImpl getInstance() {
        if (instance == null) {
            instance = new ProfilerReportServiceImpl();
        }
        return instance;
    }

    public void offerData(String sessionId, String dataType, byte[] buffer) {
        this.sendMessage(sessionId, dataType, buffer, (short)12);
    }

    public void offerResponse(String sessionId, String dataType, byte[] buffer) {
        this.sendMessage(sessionId, dataType, buffer, (short)14);
    }

    private void sendMessage(String sessionId, String dataType, byte[] buffer, short msgType) {
        try {
            ProfileMessage profileMessage = new ProfileMessage(msgType);
            profileMessage.setMessageId(MessageIdGenerator.generateMessageId());
            profileMessage.setHeader(ReportDataBuilder.buildProfileMessageHeader(sessionId, dataType));
            profileMessage.setBodyBytes(buffer);
            LOGGER.log(Level.FINE, String.format("[debug mode]sending message:[%s]", profileMessage.getHeadString()));
            if (this.invokerService.isSendEnable()) {
                this.invokerService.sendDataReport((MessageWrapper)profileMessage);
                LOGGER.log(Level.FINE, String.format("[debug mode]sending profile msg success:[%s]", profileMessage.getMessageId()));
            } else {
                APMCollector.onDiscard((String)"ProfileMessage", (long)buffer.length);
            }
            APMCollector.onSuccess((String)"ProfileMessage", (long)buffer.length);
        }
        catch (Throwable e) {
            Level level = Level.SEVERE;
            if (this.hasException) {
                level = Level.FINE;
            }
            LOGGER.log(level, "failed to send data,error message:" + e.getMessage() + ",type:" + e.getClass().getName(), e);
            APMCollector.onThrowable((String)"ProfileMessage", (long)buffer.length, (Throwable)e);
            this.hasException = true;
        }
    }
}

