/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.core.executor.timer;

import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.core.executor.timer.Timeout;
import com.lubanops.apm.core.executor.timer.Timer;
import com.lubanops.apm.core.executor.timer.TimerTask;
import java.util.concurrent.TimeUnit;

public abstract class AbstractTimerTask
implements TimerTask {
    private static final Logger LOGGER = LogFactory.getLogger();
    protected volatile boolean cancel = false;
    private volatile Long tick;

    public AbstractTimerTask(Long tick) {
        this.tick = tick;
    }

    static Long now() {
        return System.currentTimeMillis();
    }

    public void cancel() {
        this.cancel = true;
    }

    public void reput(Timeout timeout, Long tick) {
        if (timeout == null || tick == null) {
            throw new IllegalArgumentException();
        }
        if (this.cancel) {
            return;
        }
        Timer timer = timeout.timer();
        if (timer.isStop() || timeout.isCancelled()) {
            return;
        }
        timer.newTimeout(timeout.task(), tick, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run(Timeout timeout) throws Exception {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, String.format("task[%s]tick[%s] running.", this.getName(), this.tick));
        }
        this.doTask();
        this.reput(timeout, this.tick);
    }

    public abstract void doTask();

    public Long getTick() {
        return this.tick;
    }

    public void setTick(Long tick) {
        this.tick = tick;
    }
}

