/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.clickhouse.collector;

import com.lubanops.apm.bootstrap.collector.api.Collector;
import com.lubanops.apm.bootstrap.collector.api.MetricSetAggregator;
import com.lubanops.apm.bootstrap.plugin.common.DefaultVersionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.ConnectionStats;
import com.lubanops.apm.bootstrap.plugin.sql.collector.JdbcStatsAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlExceptionAggregator;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlStats;
import com.lubanops.apm.bootstrap.plugin.sql.collector.SqlStatsConfig;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import com.lubanops.apm.plugin.clickhouse.collector.ClickHouseConnectionAggregator;
import com.lubanops.apm.plugin.clickhouse.collector.ClickHouseStatsAggregator;
import java.util.Map;

public class ClickHouseCollector
extends Collector {
    public static final ClickHouseCollector INSTANCE = new ClickHouseCollector();
    public static final SqlStatsConfig CONFIG = new SqlStatsConfig();
    public static final DefaultVersionAggregator VERSION_AGGREGATOR = new DefaultVersionAggregator();
    public static final ClickHouseConnectionAggregator CLICKHOUSE_CONNECTION_AGGREGATOR = new ClickHouseConnectionAggregator();
    public static final JdbcStatsAggregator CLICKHOUSE_STATS_AGGREGATOR = new ClickHouseStatsAggregator();
    public static final SqlExceptionAggregator SQL_EXCEPTION_AGGREGATOR = new SqlExceptionAggregator();

    public static void setDriverVersion(String v) {
        VERSION_AGGREGATOR.setVersion(v);
    }

    public static void onConnectionCreated(int connectionId) {
        if (connectionId >= 0) {
            CLICKHOUSE_CONNECTION_AGGREGATOR.onConnectionCreated(connectionId);
        }
    }

    public static void onConnectionDestroyed(int connectionId) {
        if (connectionId >= 0) {
            CLICKHOUSE_CONNECTION_AGGREGATOR.onConnectionDestoyed(connectionId);
        }
    }

    public static ConnectionStats onConnectionStart(int connectionId, String clusterUrls, String sql) {
        if (connectionId < 0) {
            return null;
        }
        return CLICKHOUSE_CONNECTION_AGGREGATOR.onConnectionStart(connectionId, clusterUrls);
    }

    public static void onConnectionException(Throwable t, String sql) {
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        CLICKHOUSE_CONNECTION_AGGREGATOR.onError(sql);
        SQL_EXCEPTION_AGGREGATOR.onThrowable(t, sql);
    }

    public static void onConnectionEnd(String sql, int updatedCount, int readRowCount) {
        if (updatedCount < 0) {
            updatedCount = 0;
        }
        if (readRowCount < 0) {
            readRowCount = 0;
        }
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        CLICKHOUSE_CONNECTION_AGGREGATOR.onFinally(sql, updatedCount, readRowCount, "ClickHouse");
    }

    public static SqlStats onStart(String sql, Integer connectionId) {
        if (!INSTANCE.isEnable() || StringUtils.isBlank((String)sql)) {
            return null;
        }
        if (sql.length() > CONFIG.getSqlSize()) {
            sql = sql.substring(0, CONFIG.getSqlSize());
        }
        return CLICKHOUSE_STATS_AGGREGATOR.onStart(sql, connectionId);
    }

    public static void onThrowable(Throwable th) {
        CLICKHOUSE_STATS_AGGREGATOR.onThrowable(th);
    }

    public static void onFinally(int updatedRowCount, int readRowCount) {
        CLICKHOUSE_STATS_AGGREGATOR.onFinally(updatedRowCount, readRowCount, CONFIG.getSlowSqlThreshold());
    }

    public void parseParameter(Map<String, String> parameters) {
        if (parameters == null) {
            return;
        }
        CLICKHOUSE_STATS_AGGREGATOR.parseParameters(parameters);
    }

    public String getCollectorName() {
        return "ClickHouse";
    }

    static {
        INSTANCE.addModelAggregator((MetricSetAggregator)VERSION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CLICKHOUSE_CONNECTION_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)CLICKHOUSE_STATS_AGGREGATOR);
        INSTANCE.addModelAggregator((MetricSetAggregator)SQL_EXCEPTION_AGGREGATOR);
        INSTANCE.register();
    }
}

