/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.exception.common.stats;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.StatsBase;
import com.lubanops.apm.bootstrap.config.ConfigManager;
import com.lubanops.apm.bootstrap.utils.ExceptionUtil;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class ExceptionStats
implements StatsBase {
    private AtomicInteger count = new AtomicInteger(0);
    private AtomicLong messageTime = new AtomicLong(0L);
    private AtomicReference<String> message = new AtomicReference();
    private AtomicReference<String> stackTrace = new AtomicReference();
    private final AtomicReference<String> errorTraceId = new AtomicReference();
    private int countLast = 0;

    public void onLog(Object m, Throwable th) {
        this.count.getAndIncrement();
        if (this.messageTime.get() == 0L) {
            long t = System.currentTimeMillis();
            this.messageTime.set(t);
            String msg = null;
            if (m == null) {
                if (th != null) {
                    msg = th.getMessage();
                }
            } else {
                msg = m.toString();
            }
            this.message.set(msg);
            if (th != null) {
                String s = ExceptionUtil.getThrowableStackTrace((Throwable)th, (boolean)ConfigManager.isHideExceptionMessage());
                this.stackTrace.set(s);
            }
        }
    }

    public MonitorDataRow getStatus() {
        MonitorDataRow row = new MonitorDataRow();
        row.put((Object)"count", (Object)this.count.get());
        row.put((Object)"message", (Object)this.message.get());
        row.put((Object)"stackTrace", (Object)this.stackTrace.get());
        row.put((Object)"errorTraceId", (Object)this.errorTraceId.get());
        return row;
    }

    public MonitorDataRow harvest() {
        int c = this.count.get();
        int countHarvest = c - this.countLast;
        if (countHarvest <= 0) {
            return null;
        }
        this.countLast = c;
        MonitorDataRow row = new MonitorDataRow();
        this.messageTime.set(0L);
        row.put((Object)"count", (Object)countHarvest);
        row.put((Object)"message", this.message.getAndSet(null));
        row.put((Object)"stackTrace", this.stackTrace.getAndSet(null));
        row.put((Object)"errorTraceId", this.errorTraceId.getAndSet(null));
        return row;
    }

    public void setErrorTraceId(String errorTraceId) {
        if (this.errorTraceId.get() == null && errorTraceId != null) {
            this.errorTraceId.set(errorTraceId);
        }
    }
}

