/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.jedis.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.TransformAccess;
import com.lubanops.apm.plugin.jedis.collector.JedisCollector;
import redis.clients.jedis.BinaryJedis;

public class JedisConstructorInterceptor
implements Interceptor {
    private JedisCollector jedisCollector = JedisCollector.getInstance();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        if ("redis/clients/jedis/BinaryJedisCluster".equals(className) || "redis/clients/jedis/JedisCluster".equals(className)) {
            this.jedisCollector.mode("cluster");
        } else if ("redis/clients/jedis/BinaryJedis".equals(className) || "redis/clients/jedis/Jedis".equals(className)) {
            this.jedisCollector.mode("standalone");
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        if (object instanceof TransformAccess) {
            TransformAccess transformAccess = (TransformAccess)object;
            Object connectionIdObject = transformAccess.getLopsAttribute();
            if (null != connectionIdObject && connectionIdObject.toString().length() > 0) {
                return;
            }
            BinaryJedis binaryJedis = (BinaryJedis)object;
            transformAccess.setLopsAttribute((Object)JedisCollector.registerConnectionResource(binaryJedis.getClient().getHost(), binaryJedis.getClient().getPort()));
        }
    }
}

