/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.cloud.profiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ArtifactsScanner {
    private static final Logger logger = new Logger();
    private static final byte[] BUFFER = new byte[1024];
    private static final CustomByteArrayOutputStream BOUS = new CustomByteArrayOutputStream();

    public static final String[] scan4userPackages() throws Throwable {
        String[] userPackages = UserPackagesScanner.scan4userPackages();
        if (userPackages != null && logger.shouldLog(Level.FINER)) {
            logger.info("found " + userPackages.length + " user packages");
            Arrays.stream(userPackages).forEach(System.out::println);
        }
        return userPackages;
    }

    public static final String[] scan4Dependencies() throws Throwable {
        return MavenDependenciesScanner.scan();
    }

    private static final class CustomByteArrayOutputStream
    extends ByteArrayOutputStream {
        private CustomByteArrayOutputStream() {
        }

        public final byte[] getBuffer() {
            return this.buf;
        }

        public final int getLen() {
            return this.count;
        }
    }

    private static final class Logger {
        private static Level logLevel = Logger.initLoggingLevel();
        private int levelInt = logLevel.intValue();

        private Logger() {
        }

        private static final Level initLoggingLevel() {
            return Level.parse(System.getProperty("artifact.scanner.log.level", "INFO"));
        }

        final boolean shouldLog(Level level) {
            return this.levelInt <= level.intValue();
        }

        final void log(Level level, String msg, Throwable t) {
            if (this.shouldLog(level)) {
                logger.info(msg);
                logger.log(Level.SEVERE, t.getMessage(), t);
            }
        }

        final void severe(String msg) {
            if (this.shouldLog(Level.SEVERE)) {
                logger.info(msg);
            }
        }

        final void warning(String msg) {
            if (this.shouldLog(Level.WARNING)) {
                logger.warning(msg);
            }
        }

        final void info(String msg) {
            if (this.shouldLog(Level.INFO)) {
                logger.info(msg);
            }
        }

        final void finer(String msg) {
            if (this.shouldLog(Level.FINER)) {
                logger.finer(msg);
            }
        }

        final void finest(String msg) {
            if (this.shouldLog(Level.FINEST)) {
                logger.finest(msg);
            }
        }
    }

    private static final class UserPackagesScanner {
        private static final String BOOT_INF_CLASSES = "BOOT-INF/classes/";

        private UserPackagesScanner() {
        }

        public static final String[] scan4userPackages() throws Throwable {
            String cmd = System.getProperty("sun.java.command");
            Set<String> userPackages = null;
            boolean jarContext = false;
            String path = cmd;
            if (cmd != null) {
                String[] args;
                for (String arg : args = cmd.split("\\s+")) {
                    if (arg.endsWith(".jar")) {
                        jarContext = true;
                        path = arg;
                        break;
                    }
                    if (arg.startsWith("-") || arg.startsWith("-D")) continue;
                    path = arg;
                    break;
                }
                userPackages = jarContext ? UserPackagesScanner.scanJar4userPackages(path) : UserPackagesScanner.scanDir4userPackages(path, false);
            }
            if (userPackages == null) {
                return null;
            }
            return (String[])userPackages.stream().toArray(String[]::new);
        }

        private static final void extractMainClassPackage(JarFile jarFile, UPContext ctx) throws Throwable {
            String[] mainClassPackageParts = null;
            Manifest manifest = jarFile.getManifest();
            if (manifest != null) {
                String mainClassPackage = manifest.getMainAttributes().getValue("Start-Class");
                if (mainClassPackage == null) {
                    mainClassPackage = manifest.getMainAttributes().getValue("Main-Class");
                }
                if (mainClassPackage != null) {
                    mainClassPackage = mainClassPackage.substring(0, mainClassPackage.lastIndexOf(46));
                    ctx.userPackages.add(mainClassPackage);
                    mainClassPackageParts = mainClassPackage.split("\\.");
                }
                ctx.mainClassPackageParts = mainClassPackageParts;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Set<String> scanJar4userPackages(String path) throws Throwable {
            Path jarPath = Paths.get(path, new String[0]);
            if (!Files.exists(jarPath, new LinkOption[0])) {
                logger.severe("jar " + path + " does not exist - aborting user packages scan");
                return null;
            }
            try (UPContext ctx = null;){
                ctx = new UPContext();
                try (JarFile jarFile = new JarFile(jarPath.toFile());){
                    JarEntry bootInf = jarFile.getJarEntry(BOOT_INF_CLASSES);
                    String scanPrefix = "";
                    if (bootInf != null) {
                        scanPrefix = BOOT_INF_CLASSES;
                        ctx.isSpringBoot = true;
                    }
                    UserPackagesScanner.extractMainClassPackage(jarFile, ctx);
                    UserPackagesScanner.scan4userPackages(jarPath, scanPrefix, ctx);
                }
            }
            return ctx.userPackages;
        }

        private static final void scan4userPackages(Path jarPath, String scanPrefix, UPContext ctx) throws Throwable {
            for (int i = 0; i < 4; ++i) {
                ctx.submit(() -> {
                    int taskId = ctx.provisionTaskId();
                    AtomicInteger fileCounter = new AtomicInteger();
                    AtomicInteger handledFileCounter = new AtomicInteger();
                    try (JarFile jf = new JarFile(jarPath.toFile());){
                        Enumeration<JarEntry> entries = jf.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry entry = entries.nextElement();
                            String name = entry.getName();
                            if (fileCounter.incrementAndGet() % 4 != taskId) continue;
                            handledFileCounter.incrementAndGet();
                            if (name == null && entry.isDirectory() || name.equals("module-info.class") || !name.endsWith(".class") && !name.endsWith(".jar")) continue;
                            if (logger.shouldLog(Level.FINEST)) {
                                logger.finest(Thread.currentThread() + " --> " + name);
                            }
                            try {
                                if (name.endsWith(".jar")) {
                                    try {
                                        UserPackagesScanner.scanInnerJar4userPackages(jf.getInputStream(entry), name, ctx);
                                        if (logger.shouldLog(Level.FINER)) {
                                            logger.finer("user package scanning finished for " + name);
                                        }
                                    }
                                    catch (Throwable t) {
                                        logger.log(Level.SEVERE, "failed to scan file " + name + ", skipping", t);
                                    }
                                    if (!logger.shouldLog(Level.FINER)) continue;
                                    logger.finer("submitted jar user package scan task " + name);
                                    continue;
                                }
                                UserPackagesScanner.scanJarEntry4UserPackage(name, scanPrefix, ctx.isSpringBoot, ctx);
                            }
                            catch (Throwable t) {
                                logger.log(Level.SEVERE, "failed to scan file " + name + ", skipping", t);
                            }
                        }
                        if (logger.shouldLog(Level.FINEST)) {
                            logger.finest(Thread.currentThread() + " handled Files: " + handledFileCounter.get());
                        }
                        Integer n = taskId;
                        return n;
                    }
                });
            }
        }

        private static final void scanInnerJar4userPackages(InputStream is, String filename, UPContext ctx) throws Throwable {
            try (ZipInputStream zis = new ZipInputStream(is);){
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    String name = entry.getName();
                    UserPackagesScanner.scanJarEntry4UserPackage(name, "", false, ctx);
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Failed to open zipinputstream for " + filename, t);
            }
        }

        private static final void scanJarEntry4UserPackage(String name, String scanPrefix, boolean isSpringBoot, UPContext ctx) throws Throwable {
            String aPackage;
            if (name.isEmpty() || !name.startsWith(scanPrefix)) {
                return;
            }
            if (name.charAt(0) == '/') {
                name = name.substring(1);
            }
            if (!ctx.userPackages.contains(aPackage = UserPackagesScanner.extractPackageFromInternalJarPath(name, scanPrefix)) && UserPackagesScanner.isUserPackage(aPackage, ctx.mainClassPackageParts, isSpringBoot)) {
                ctx.userPackages.add(aPackage);
            }
        }

        private static final boolean isUserPackage(String candidate, String[] mainClassPackageParts, boolean isSpringBoot) {
            int minMatchDepth;
            if (isSpringBoot || mainClassPackageParts == null) {
                return true;
            }
            String[] candidateParts = candidate.split("\\.");
            int n = minMatchDepth = mainClassPackageParts.length < 3 ? mainClassPackageParts.length : 3;
            if (candidateParts.length < minMatchDepth) {
                return false;
            }
            for (int i = 0; i < minMatchDepth; ++i) {
                if (candidateParts[i].equals(mainClassPackageParts[i])) continue;
                return false;
            }
            return true;
        }

        private static final String extractPackageFromInternalJarPath(String path, String prefix) {
            int prefixLength = prefix.length();
            int lastIndexOfPathSeparator = path.lastIndexOf(47);
            lastIndexOfPathSeparator = lastIndexOfPathSeparator == -1 ? path.length() : lastIndexOfPathSeparator;
            try {
                return path.substring(prefixLength, lastIndexOfPathSeparator).replace('/', '.');
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, t.getMessage(), t);
                return "";
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static final Set<String> scanDir4userPackages(String className, boolean actuallyaDir) throws Throwable {
            try {
                String clsLocation = null;
                if (!actuallyaDir) {
                    Class<?> cls = Class.forName(className);
                    clsLocation = cls.getProtectionDomain().getCodeSource().getLocation().getPath();
                } else {
                    clsLocation = className;
                }
                if (clsLocation.charAt(0) == '/') {
                    clsLocation = clsLocation.substring(1);
                }
                if (!(clsLocation = Paths.get(clsLocation, new String[0]).toAbsolutePath().toString()).endsWith(File.separator)) {
                    clsLocation = clsLocation + File.separator;
                }
                int clsLocationLen = clsLocation.length();
                Path clsLocationPath = Paths.get(clsLocation, new String[0]);
                if (logger.shouldLog(Level.FINEST)) {
                    logger.finest("class Location : " + clsLocation);
                }
                if (!Files.isDirectory(clsLocationPath, new LinkOption[0])) {
                    if (!clsLocation.endsWith(".jar")) throw new IllegalArgumentException("java command format is unknown " + clsLocation);
                    return UserPackagesScanner.scanJar4userPackages(clsLocation);
                }
                try (Stream<Path> fileAndDirs = Files.walk(clsLocationPath, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".class"));){
                    Set<String> set = fileAndDirs.map(p -> {
                        String path = p.toAbsolutePath().toString();
                        int lastIndexOfSeparator = path.lastIndexOf(File.separatorChar);
                        return path.substring(clsLocationLen, lastIndexOfSeparator).replace(File.separatorChar, '.');
                    }).collect(Collectors.toSet());
                    return set;
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, t.getMessage(), t);
                return null;
            }
        }
    }

    private static final class MavenDependenciesScanner {
        private MavenDependenciesScanner() {
        }

        public static final String[] scan() throws Throwable {
            Set<String> classPath = MavenDependenciesScanner.getClassPath();
            String[] dependencies = MavenDependenciesScanner.scan(classPath);
            if (logger.shouldLog(Level.FINER)) {
                logger.info("found " + dependencies.length + " dependencies");
                Arrays.stream(dependencies).forEach(System.out::println);
                logger.info("\ndependenceies without group Id or version");
                Arrays.stream(dependencies).filter(d -> d.charAt(0) == ':' || d.charAt(d.length() - 1) == ':').forEach(System.out::println);
            }
            return dependencies;
        }

        private static final Set<String> getClassPath() {
            String classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
            return Arrays.stream(classPath.split(File.pathSeparator)).collect(Collectors.toSet());
        }

        private static final String[] scan(Collection<String> classPath) throws Throwable {
            HashSet<MvnDependency> dependencies = new HashSet<MvnDependency>();
            for (String cpElement : classPath) {
                if (cpElement.endsWith("*") || !cpElement.endsWith(".jar")) {
                    MavenDependenciesScanner.scanDirectory(cpElement, dependencies);
                    continue;
                }
                if (cpElement.endsWith(".jar")) {
                    MavenDependenciesScanner.scanJar(Paths.get(cpElement, new String[0]), dependencies);
                    continue;
                }
                if (!logger.shouldLog(Level.WARNING)) continue;
                logger.warning("unknown classpath element format, ignoring " + cpElement);
            }
            return (String[])dependencies.stream().map(m -> m.toString()).toArray(String[]::new);
        }

        private static final void scanDirectory(String directory, Set<MvnDependency> dependencies) throws Throwable {
            boolean scanClasses = false;
            if (!directory.endsWith("*")) {
                scanClasses = true;
            } else {
                directory = directory.substring(0, directory.length() - 1);
            }
            Path dirPath = Paths.get(directory, new String[0]);
            if (!Files.exists(dirPath, new LinkOption[0]) && logger.shouldLog(Level.WARNING)) {
                logger.warning("not a valid dir, skipping scan " + dirPath);
            }
            try (Stream<Path> s = Files.list(dirPath);){
                s.filter(f -> f.endsWith("jar") || f.endsWith("JAR")).forEach(p -> {
                    try {
                        MavenDependenciesScanner.scanJar(p, dependencies);
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, t.getMessage(), t);
                    }
                });
            }
            if (scanClasses) {
                try (Stream<Path> files = Files.find(dirPath, Integer.MAX_VALUE, (path, attr) -> path.toString().contains("pom.properties"), new FileVisitOption[0]);){
                    files.forEach(p -> {
                        try {
                            MvnDependency dependency = MavenDependenciesScanner.readPomProperties(p);
                            dependencies.add(dependency);
                        }
                        catch (IOException ioe) {
                            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
                        }
                    });
                }
            }
        }

        private static final boolean accept(URL url) {
            String fileName = url.getFile();
            if (fileName.endsWith("jar")) {
                return true;
            }
            String[] fileNameParts = fileName.split("!/");
            return fileNameParts.length == 2 && fileNameParts[1].endsWith(".jar");
        }

        private static final void scanJar(Path path, Set<MvnDependency> dependencies) throws Throwable {
            MavenDependenciesScanner.scanJar(path.toUri().toURL(), dependencies);
        }

        private static final void scanJar(URL url, Set<MvnDependency> dependencies) throws Throwable {
            if (!MavenDependenciesScanner.accept(url)) {
                if (logger.shouldLog(Level.FINER)) {
                    logger.finer(url.getFile() + " is not a valid jar, aborting ");
                }
                return;
            }
            if (logger.shouldLog(Level.FINEST)) {
                logger.finest("scanning artifact " + url);
            }
            try (InputStream is = url.openStream();){
                MavenDependenciesScanner.scanJar(url.getFile(), is, dependencies, true);
            }
        }

        private static final void deriveDependencyFromFileName(String path, Set<MvnDependency> dependencies) {
            try {
                String version;
                String artifactId;
                String fileName = new File(path).getName();
                int indexOfExtension = fileName.lastIndexOf(46);
                fileName = fileName.substring(0, indexOfExtension);
                int lastIndexOfHyphen = fileName.lastIndexOf(45);
                if (lastIndexOfHyphen != -1) {
                    artifactId = fileName.substring(0, lastIndexOfHyphen);
                    version = fileName.substring(lastIndexOfHyphen + 1);
                } else {
                    artifactId = fileName;
                    version = "";
                }
                MvnDependency dependency = new MvnDependency("", artifactId, version);
                dependencies.add(dependency);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "failed to derive dependency coordinates from file name " + path, t);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void scanJar(String path, InputStream is, Set<MvnDependency> dependencies, boolean recursive) throws Throwable {
            boolean hasPomProperties = false;
            try (ZipInputStream jis = new ZipInputStream(is);){
                ZipEntry entry = null;
                while ((entry = jis.getNextEntry()) != null) {
                    String name = entry.getName();
                    if (name.endsWith("pom.properties")) {
                        try {
                            hasPomProperties = true;
                            if (logger.shouldLog(Level.FINEST)) {
                                logger.finest(path + " reading entry " + path + "/" + name);
                            }
                            MvnDependency dependency = MavenDependenciesScanner.readPomProperties(jis, entry);
                            dependencies.add(dependency);
                            if (recursive) continue;
                            break;
                        }
                        catch (IOException ioe) {
                            logger.log(Level.SEVERE, "Failed to read pom.properties", ioe);
                            continue;
                        }
                        finally {
                            jis.closeEntry();
                            continue;
                        }
                    }
                    if (!recursive || !name.endsWith(".jar")) continue;
                    try {
                        InputStream entryIs = MavenDependenciesScanner.readZipEntry(jis, entry);
                        try {
                            MavenDependenciesScanner.scanJar(name, entryIs, dependencies, false);
                        }
                        finally {
                            if (entryIs == null) continue;
                            entryIs.close();
                        }
                    }
                    finally {
                        jis.closeEntry();
                    }
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Failed to open zipinputstream for " + path, t);
            }
            if (!hasPomProperties) {
                if (logger.shouldLog(Level.FINEST)) {
                    logger.finest("jar " + path + " has no pom properties, extracting artifact Id and version from file name");
                }
                MavenDependenciesScanner.deriveDependencyFromFileName(path, dependencies);
            }
        }

        private static final MvnDependency readPomProperties(ZipInputStream jis, ZipEntry entry) throws IOException {
            try (InputStream entryIs = MavenDependenciesScanner.readZipEntry(jis, entry);){
                MvnDependency mvnDependency = MavenDependenciesScanner.readPomProperties(entryIs);
                return mvnDependency;
            }
        }

        private static final MvnDependency readPomProperties(Path path) throws IOException {
            try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                MvnDependency mvnDependency = MavenDependenciesScanner.readPomProperties(is);
                return mvnDependency;
            }
        }

        private static final MvnDependency readPomProperties(InputStream is) throws IOException {
            Properties pomProps = new Properties();
            pomProps.load(is);
            MvnDependency dep = new MvnDependency(pomProps.getProperty("groupId"), pomProps.getProperty("artifactId"), pomProps.getProperty("version"));
            return dep;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final InputStream readZipEntry(InputStream is, ZipEntry entry) throws IOException {
            try {
                ByteArrayInputStream bis;
                int len = 0;
                while ((len = is.read(BUFFER)) > -1) {
                    BOUS.write(BUFFER, 0, len);
                }
                ByteArrayInputStream byteArrayInputStream = bis = new ByteArrayInputStream(BOUS.getBuffer(), 0, BOUS.getLen());
                return byteArrayInputStream;
            }
            finally {
                BOUS.reset();
            }
        }
    }

    public static final class MvnDependency {
        private String group;
        private String name;
        private String version;

        public MvnDependency(String group, String name, String version) {
            this.group = group;
            this.name = name;
            this.version = version;
        }

        public final String toString() {
            return this.group + ":" + this.name + ":" + this.version;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MvnDependency other = (MvnDependency)obj;
            if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }
    }

    private static final class UPContext
    implements Closeable {
        private static final int NO_OF_TASKS = 4;
        private static final AtomicInteger taskIdCounter = new AtomicInteger();
        final Set<String> userPackages = ConcurrentHashMap.newKeySet();
        String[] mainClassPackageParts;
        final ExecutorCompletionService<Integer> executor;
        final ExecutorService _executor = Executors.newFixedThreadPool(4);
        int tasksCount;
        boolean isSpringBoot;

        UPContext() {
            this.executor = new ExecutorCompletionService(this._executor);
        }

        void submit(Callable<Integer> c) {
            this.executor.submit(c);
            ++this.tasksCount;
        }

        int provisionTaskId() {
            return taskIdCounter.getAndIncrement();
        }

        @Override
        public final void close() throws IOException {
            if (logger.shouldLog(Level.FINER)) {
                logger.finer("awating " + this.tasksCount + " tasks");
            }
            for (int i = 0; i < this.tasksCount; ++i) {
                try {
                    int taskId = this.executor.take().get();
                    if (logger.shouldLog(Level.FINER)) {
                        logger.finer("finshed extracting user packages from task " + taskId);
                    }
                    taskIdCounter.set(0);
                    continue;
                }
                catch (Throwable t) {
                    if (!logger.shouldLog(Level.FINER)) continue;
                    logger.log(Level.SEVERE, "failed to shutdown user package scanning executors service", t);
                }
            }
            this._executor.shutdownNow();
        }
    }
}

