/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.rocketmq.producer.interceptor;

import com.lubanops.apm.bootstrap.AttributeAccess;
import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.rocketmq.RocketMqUtils;
import com.lubanops.apm.plugin.rocketmq.producer.collector.RocketMqProducerCollector;
import org.apache.rocketmq.client.impl.producer.DefaultMQProducerImpl;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.LocalTransactionState;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.client.producer.TransactionSendResult;
import org.apache.rocketmq.common.message.Message;

public class SendMsgInTransactionInterceptor
implements Interceptor {
    private final ThreadLocal<Boolean> hasErrorLocal = new ThreadLocal();

    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (RocketMqProducerCollector.INSTANCE.isEnable()) {
                DefaultMQProducerImpl producerImp = (DefaultMQProducerImpl)object;
                DefaultMQProducer producer = (DefaultMQProducer)((AttributeAccess)producerImp).getLopsFileds()[0];
                String clientId = RocketMqUtils.getClientId(producerImp);
                String group = producer.getProducerGroup();
                Message msg = (Message)args[0];
                String transactionId = msg.getTransactionId();
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"RocketMqProducer");
                RocketMqProducerCollector.onTransactionStart(clientId, group);
                if (spanEvent != null) {
                    spanEvent.addTag("transactionId", transactionId);
                }
            }
        }
        catch (Exception transactionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)transactionException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (RocketMqProducerCollector.INSTANCE.isEnable()) {
                RocketMqProducerCollector.onException(e);
                TraceCollector.onError((Throwable)e);
                this.hasErrorLocal.set(Boolean.TRUE);
            }
        }
        catch (Exception transactionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)transactionException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (RocketMqProducerCollector.INSTANCE.isEnable()) {
                boolean isTransactionFailed = false;
                if (Boolean.TRUE.equals(this.hasErrorLocal.get())) {
                    isTransactionFailed = true;
                }
                TransactionSendResult transactionResult = (TransactionSendResult)result;
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                if (result != null) {
                    SendStatus sendStatus = transactionResult.getSendStatus();
                    LocalTransactionState localTransactionState = transactionResult.getLocalTransactionState();
                    if (!SendStatus.SEND_OK.equals((Object)sendStatus)) {
                        isTransactionFailed = true;
                    }
                    if (!LocalTransactionState.COMMIT_MESSAGE.equals((Object)localTransactionState)) {
                        isTransactionFailed = true;
                    }
                    if (spanEvent != null) {
                        spanEvent.addTag("sendResult", sendStatus.name());
                        spanEvent.addTag("localTransactionState", localTransactionState.name());
                    }
                }
                if (isTransactionFailed) {
                    RocketMqProducerCollector.onTransactionError(TraceCollector.getTraceId());
                }
                RocketMqProducerCollector.onTransactionFinally();
                TraceCollector.onFinally();
                this.hasErrorLocal.remove();
            }
        }
        catch (Exception transactionException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)transactionException);
        }
    }
}

