/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import one.jfr.ClassRef;
import one.jfr.Dictionary;
import one.jfr.JfrReader;
import one.jfr.MethodRef;
import one.jfr.StackTrace;
import one.jfr.event.ExecutionSample;
import one.proto.Proto;

public class jfr2pprof {
    public static final byte[] METHOD_UNKNOWN = "[unknown]".getBytes();
    public static final int PROFILE_SAMPLE_TYPE = 1;
    public static final int PROFILE_SAMPLE = 2;
    public static final int PROFILE_LOCATION = 4;
    public static final int PROFILE_FUNCTION = 5;
    public static final int PROFILE_STRING_TABLE = 6;
    public static final int PROFILE_TIME_NANOS = 9;
    public static final int PROFILE_DURATION_NANOS = 10;
    public static final int PROFILE_COMMENT = 13;
    public static final int PROFILE_DEFAULT_SAMPLE_TYPE = 14;
    public static final int VALUETYPE_TYPE = 1;
    public static final int VALUETYPE_UNIT = 2;
    public static final int SAMPLE_LOCATION_ID = 1;
    public static final int SAMPLE_VALUE = 2;
    public static final int LOCATION_ID = 1;
    public static final int LOCATION_LINE = 4;
    public static final int LINE_FUNCTION_ID = 1;
    public static final int LINE_LINE = 2;
    public static final int FUNCTION_ID = 1;
    public static final int FUNCTION_NAME = 2;
    private final JfrReader reader;

    public jfr2pprof(JfrReader jfrReader) {
        this.reader = jfrReader;
    }

    public void dump(OutputStream outputStream) throws Exception {
        int n = 1;
        int n2 = 1;
        int n3 = 1;
        HashMap<Method, Integer> hashMap = new HashMap<Method, Integer>();
        HashMap<Method, Integer> hashMap2 = new HashMap<Method, Integer>();
        Proto proto = new Proto(200000).field(9, this.reader.startNanos).field(10, this.reader.durationNanos()).field(14, 0L).field(6, "".getBytes(StandardCharsets.UTF_8)).field(6, "async-profiler".getBytes(StandardCharsets.UTF_8)).field(13, n3++);
        Proto proto2 = new Proto(100);
        proto.field(6, "cpu".getBytes(StandardCharsets.UTF_8));
        proto2.field(1, n3++);
        proto.field(6, "nanoseconds".getBytes(StandardCharsets.UTF_8));
        proto2.field(2, n3++);
        proto.field(1, proto2);
        List<ExecutionSample> list = this.reader.readAllEvents(ExecutionSample.class);
        Dictionary<StackTrace> dictionary = this.reader.stackTraces;
        long l = this.reader.startTicks;
        for (ExecutionSample executionSample : list) {
            StackTrace stackTrace = dictionary.get(executionSample.stackTraceId);
            long[] lArray = stackTrace.methods;
            byte[] byArray = stackTrace.types;
            long l2 = (executionSample.time - l) * 1000000000L / this.reader.ticksPerSec;
            Proto proto3 = new Proto(1000).field(2, l2);
            for (int i = 0; i < lArray.length; ++i) {
                Integer n4;
                byte by = byArray[i];
                long l3 = lArray[i];
                byte[] byArray2 = this.getMethodName(l3, by);
                Method method = new Method(byArray2);
                int n5 = stackTrace.locations[i] >>> 16;
                Integer n6 = (Integer)hashMap.get(method);
                if (null == n6) {
                    int n7 = n++;
                    proto.field(6, byArray2);
                    Proto proto4 = new Proto(16).field(1, n7).field(2, n3++);
                    proto.field(5, proto4);
                    hashMap.put(method, n7);
                }
                if (null == (n4 = (Integer)hashMap2.get(method))) {
                    int n8 = n2++;
                    Proto proto5 = new Proto(16).field(1, (Integer)hashMap.get(method));
                    if (n5 > 0) {
                        proto5.field(2, n5);
                    }
                    Proto proto6 = new Proto(16).field(1, n8).field(4, proto5);
                    proto.field(4, proto6);
                    hashMap2.put(method, n8);
                }
                proto3.field(1, (Integer)hashMap2.get(method));
            }
            proto.field(2, proto3);
            l = executionSample.time;
        }
        outputStream.write(proto.buffer(), 0, proto.size());
    }

    private byte[] getMethodName(long l, byte by) {
        MethodRef methodRef = this.reader.methods.get(l);
        if (null == methodRef) {
            return METHOD_UNKNOWN;
        }
        ClassRef classRef = this.reader.classes.get(methodRef.cls);
        byte[] byArray = this.reader.symbols.get(classRef.name);
        byte[] byArray2 = this.reader.symbols.get(methodRef.name);
        if (by >= 3 && by <= 5 || byArray == null || byArray.length == 0) {
            return byArray2;
        }
        byte[] byArray3 = new byte[byArray.length + 1 + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        byArray3[byArray.length] = 46;
        System.arraycopy(byArray2, 0, byArray3, byArray.length + 1, byArray2.length);
        return byArray3;
    }

    public static void main(String[] stringArray) throws Exception {
        File file;
        if (stringArray.length < 2) {
            System.out.println("Usage: java " + jfr2pprof.class.getName() + " input.jfr output.pprof");
            System.exit(1);
        }
        if ((file = new File(stringArray[1])).isDirectory()) {
            file = new File(file, new File(stringArray[0]).getName().replace(".jfr", ".pprof"));
        }
        try (JfrReader jfrReader = new JfrReader(stringArray[0]);
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            new jfr2pprof(jfrReader).dump(fileOutputStream);
        }
    }

    public static class Method {
        final byte[] name;

        public Method(byte[] byArray) {
            this.name = byArray;
        }

        public int hashCode() {
            return Arrays.hashCode(this.name);
        }

        public boolean equals(Object object) {
            return object instanceof Method && Arrays.equals(this.name, ((Method)object).name);
        }
    }
}

