/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.cse.collector.consumer;

import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.collector.api.MultiPrimaryKeyAggregator;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.cse.collector.consumer.ConsumerStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSEConsumerDetailAggregator
extends MultiPrimaryKeyAggregator<ConsumerStats> {
    private static String tag_qualifiedName = "qualifiedName";
    private static String tag_method = "method";
    private static String tag_stats = "cseconsumerstats";
    private static String tag_start = "cseconsumerstart";

    public String getName() {
        return "detail";
    }

    public long onStart(String uri, String method) {
        if (!this.isEnable) {
            return 0L;
        }
        ConsumerStats stats = (ConsumerStats)this.getValue(new String[]{uri, method});
        long t = stats.onStart();
        Map map = this.getContextMap();
        map.put(tag_stats, stats);
        map.put(tag_start, t);
        return t;
    }

    public long onResponseClose(int code) {
        Map map = this.getContextMap();
        ConsumerStats stats = (ConsumerStats)((Object)this.getContextValue(map, tag_stats));
        Long start = (Long)this.getContextValue(map, tag_start);
        if (stats != null && start != null) {
            long endTime;
            long useTime;
            boolean isSlow;
            if (code >= 400) {
                stats.onError();
                stats.setErrorTraceId(TraceCollector.getTraceId());
            }
            if (isSlow = stats.onFinally(useTime = (endTime = System.nanoTime()) - start)) {
                stats.setSlowTraceId(TraceCollector.getTraceId());
            }
            return useTime;
        }
        return 0L;
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        if (collected == null || collected.isEmpty()) {
            return null;
        }
        SV totalStats = new SV();
        for (Map map : collected) {
            Long errorCount;
            Long totalTime;
            Long invokeCount = (Long)map.get("invokeCount");
            if (invokeCount != null) {
                totalStats.invokeCount = (int)((long)totalStats.invokeCount + invokeCount);
            }
            if ((totalTime = (Long)map.get("totalTime")) != null) {
                totalStats.totalTime += totalTime.longValue();
            }
            if ((errorCount = (Long)map.get("errorCount")) == null) continue;
            totalStats.errorCount = (int)((long)totalStats.errorCount + errorCount);
        }
        ArrayList<MonitorDataRow> totalRows = new ArrayList<MonitorDataRow>();
        MonitorDataRow monitorDataRow = new MonitorDataRow();
        monitorDataRow.put((Object)"invokeCount", (Object)totalStats.invokeCount);
        monitorDataRow.put((Object)"totalTime", (Object)totalStats.totalTime);
        monitorDataRow.put((Object)"errorCount", (Object)totalStats.errorCount);
        totalRows.add(monitorDataRow);
        HashMap<String, List<MonitorDataRow>> result = new HashMap<String, List<MonitorDataRow>>();
        result.put("total", totalRows);
        return result;
    }

    protected int primaryKeyLength() {
        return 2;
    }

    protected List<String> primaryKey() {
        return Arrays.asList(tag_qualifiedName, tag_method);
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    protected Class<ConsumerStats> getValueType() {
        return ConsumerStats.class;
    }

    public static class SV {
        public int invokeCount;
        public long totalTime;
        public int errorCount;
    }
}

