/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.url.collector.body;

import com.lubanops.apm.bootstrap.api.APIService;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.url.collector.config.UrlStatsConfig;
import com.lubanops.apm.bootstrap.trace.ErrorType;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.bootstrap.utils.GZIPUtils;
import com.lubanops.apm.bootstrap.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TomcatBodyData {
    private static final Logger LOGGER = LogFactory.getLogger();
    private static boolean logError = false;
    private static ThreadLocal<byte[]> requestThreadLocal = new ThreadLocal();
    private static ThreadLocal<byte[]> responseThreadLocal = new ThreadLocal();
    private static ThreadLocal<byte[]> bizErrorThreadLocal = new ThreadLocal();
    private static ThreadLocal<StringBuilder> responseWriteThreadLocal = new ThreadLocal();
    private static ThreadLocal<StringBuilder> bizErrorWriteThreadLocal = new ThreadLocal();

    public static void start() {
        requestThreadLocal.set(null);
        responseThreadLocal.set(null);
        responseWriteThreadLocal.set(null);
        bizErrorThreadLocal.set(null);
        bizErrorWriteThreadLocal.set(null);
    }

    public static void addRequestBody(byte[] newBytes) {
        if (requestThreadLocal.get() == null) {
            requestThreadLocal.set(newBytes);
        } else {
            byte[] oldBytes = requestThreadLocal.get();
            if (oldBytes.length > UrlStatsConfig.getBodyLength()) {
                return;
            }
            byte[] mergerBytes = TomcatBodyData.addBytes(oldBytes, newBytes);
            requestThreadLocal.set(mergerBytes);
        }
    }

    public static void addResponseBody(byte[] newBytes) {
        int bizMaxLength;
        if (UrlStatsConfig.isBodyDetail()) {
            if (responseThreadLocal.get() == null) {
                responseThreadLocal.set(newBytes);
            } else {
                byte[] oldBytes = responseThreadLocal.get();
                if (oldBytes.length > UrlStatsConfig.getBodyLength()) {
                    return;
                }
                byte[] mergerBytes = TomcatBodyData.addBytes(oldBytes, newBytes);
                responseThreadLocal.set(mergerBytes);
            }
        }
        if ((bizMaxLength = UrlStatsConfig.getBizCodeLength()) > 0) {
            if (bizErrorThreadLocal.get() == null) {
                bizErrorThreadLocal.set(newBytes);
            } else {
                byte[] oldBytes = bizErrorThreadLocal.get();
                if (oldBytes.length > bizMaxLength) {
                    return;
                }
                byte[] mergerBytes = TomcatBodyData.addBytes(oldBytes, newBytes);
                bizErrorThreadLocal.set(mergerBytes);
            }
        }
    }

    public static void addResponseWriteBody(String newStr) {
        int bizMaxLength;
        if (UrlStatsConfig.isBodyDetail()) {
            StringBuilder sb;
            if (responseWriteThreadLocal.get() == null) {
                sb = new StringBuilder();
                sb.append(newStr);
                responseWriteThreadLocal.set(sb);
            } else {
                sb = responseWriteThreadLocal.get();
                if (sb.length() > UrlStatsConfig.getBizCodeLength()) {
                    return;
                }
                sb.append(newStr);
            }
        }
        if ((bizMaxLength = UrlStatsConfig.getBizCodeLength()) > 0) {
            if (bizErrorWriteThreadLocal.get() == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(newStr);
                bizErrorWriteThreadLocal.set(sb);
            } else {
                StringBuilder sb = bizErrorWriteThreadLocal.get();
                if (sb.length() > bizMaxLength) {
                    return;
                }
                sb.append(newStr);
            }
        }
    }

    public static void end(String requestEnCoding, String responseEnCoding, String acceptEncoding) {
        if (requestEnCoding == null) {
            requestEnCoding = "UTF-8";
        }
        if (responseEnCoding == null) {
            responseEnCoding = "UTF-8";
        }
        byte[] requestByte = requestThreadLocal.get();
        requestThreadLocal.set(null);
        if (requestByte != null) {
            try {
                TraceCollector.addTag((String)"requestBody", (String)new String(requestByte, requestEnCoding), (int)UrlStatsConfig.getBodyLength());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        byte[] responseByte = responseThreadLocal.get();
        responseThreadLocal.set(null);
        StringBuilder sb = responseWriteThreadLocal.get();
        responseWriteThreadLocal.set(null);
        if (responseByte != null) {
            try {
                if (UrlStatsConfig.isGzip() && acceptEncoding != null && acceptEncoding.contains("gzip")) {
                    responseByte = GZIPUtils.uncompress((byte[])responseByte);
                }
                TraceCollector.addTag((String)"responseBody", (String)new String(responseByte, responseEnCoding), (int)UrlStatsConfig.getBodyLength());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (sb != null) {
            TraceCollector.addTag((String)"responseBody", (String)sb.toString(), (int)UrlStatsConfig.getBodyLength());
        }
    }

    public static void parseBizError(String responseEnCoding, String acceptEncoding) {
        block11: {
            try {
                if (responseEnCoding == null) {
                    responseEnCoding = "UTF-8";
                }
                byte[] responseByte = bizErrorThreadLocal.get();
                bizErrorThreadLocal.set(null);
                StringBuilder sb = bizErrorWriteThreadLocal.get();
                bizErrorWriteThreadLocal.set(null);
                String responseStr = null;
                if (responseByte != null) {
                    try {
                        if (UrlStatsConfig.isGzip() && acceptEncoding != null && acceptEncoding.contains("gzip")) {
                            responseByte = GZIPUtils.uncompress((byte[])responseByte);
                        }
                        responseStr = new String(responseByte, responseEnCoding);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else if (sb != null) {
                    responseStr = sb.toString();
                }
                if (responseStr == null || responseStr.length() >= UrlStatsConfig.getBizCodeLength()) break block11;
                Map map = (Map)APIService.getJsonApi().parseObject(responseStr, HashMap.class);
                for (String filed : UrlStatsConfig.getBizCodeFields()) {
                    SpanEvent span;
                    String value = TomcatBodyData.getValue(map, filed);
                    if (StringUtils.isBlank((String)value)) continue;
                    TraceCollector.addTag((String)"bizCode", (String)value);
                    if (TomcatBodyData.isBizCodeError(value) && (span = TraceCollector.getSpanEvent()) != null) {
                        span.setSpanError(true);
                        span.setErrorReasons(ErrorType.BIZCODE_ERR.name());
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (logError) break block11;
                LOGGER.log(Level.SEVERE, "parseBizError", (Throwable)e);
                logError = true;
            }
        }
    }

    private static boolean isBizCodeError(String value) {
        Set<String> bizCodeRightValues = UrlStatsConfig.getBizCodeRightValues();
        List<String> bizCodeRightValuePatterns = UrlStatsConfig.getBizCodeRightValuePatterns();
        if (bizCodeRightValues.size() > 0 || bizCodeRightValuePatterns.size() > 0) {
            if (bizCodeRightValues.contains(value)) {
                return false;
            }
            for (String pattern : bizCodeRightValuePatterns) {
                if (!value.startsWith(pattern)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String getValue(Map<String, Object> map, String filedKey) {
        String[] filedKeys = filedKey.split("[.]");
        for (int i = 0; i < filedKeys.length; ++i) {
            Object result = map.get(filedKeys[i]);
            if (result != null) {
                if (i == filedKeys.length - 1) {
                    return String.valueOf(result);
                }
                if (!(result instanceof Map)) continue;
                map = (Map)result;
                continue;
            }
            return null;
        }
        return null;
    }

    public static byte[] addBytes(byte[] data1, byte[] data2) {
        byte[] data3 = new byte[data1.length + data2.length];
        System.arraycopy(data1, 0, data3, 0, data1.length);
        System.arraycopy(data2, 0, data3, data1.length, data2.length);
        return data3;
    }
}

