/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.bootstrap.plugin.tomcat.collector;

import com.lubanops.apm.bootstrap.collector.UpdataListenerManager;
import com.lubanops.apm.bootstrap.collector.UpdateListener;
import com.lubanops.apm.bootstrap.collector.api.AbstractAggregator;
import com.lubanops.apm.bootstrap.collector.api.MonitorDataRow;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.log.Logger;
import com.lubanops.apm.bootstrap.plugin.tomcat.collector.TomcatHttpObject;
import com.lubanops.apm.bootstrap.utils.ConcurrentUtil;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class TomcatAggregator
extends AbstractAggregator
implements UpdateListener {
    private static final Logger LOGGER = LogFactory.getLogger();
    private MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private Map<String, TomcatHttpObject> map = new HashMap<String, TomcatHttpObject>();
    private boolean hasException = Boolean.FALSE;
    private int isNullTimes = 0;

    public TomcatAggregator() {
        UpdataListenerManager.registerListener((UpdateListener)this);
    }

    public String getName() {
        return "tomcat";
    }

    public List<MonitorDataRow> harvest() {
        if (this.isNullTimes > 3) {
            return null;
        }
        try {
            List<MonitorDataRow> result;
            if (this.map.size() == 0) {
                ObjectName objName = new ObjectName("Catalina:type=ThreadPool,name=*");
                ObjectName connectionObjName = new ObjectName("Catalina:type=ProtocolHandler,port=*");
                Set<ObjectName> nn = this.server.queryNames(objName, null);
                Set<ObjectName> connectionSet = this.server.queryNames(connectionObjName, null);
                if (connectionSet == null || connectionSet.isEmpty()) {
                    connectionObjName = new ObjectName("Catalina:type=ProtocolHandler,port=*,address=*");
                    connectionSet = this.server.queryNames(connectionObjName, null);
                }
                if (nn == null || nn.isEmpty()) {
                    objName = new ObjectName("Tomcat:type=ThreadPool,name=*");
                    nn = this.server.queryNames(objName, null);
                    connectionObjName = new ObjectName("Tomcat:type=ProtocolHandler,port=*");
                    connectionSet = this.server.queryNames(connectionObjName, null);
                    if (connectionSet == null || connectionSet.isEmpty()) {
                        connectionObjName = new ObjectName("Tomcat:type=ProtocolHandler,port=*,address=*");
                        connectionSet = this.server.queryNames(connectionObjName, null);
                    }
                }
                if ((nn == null || nn.isEmpty()) && (connectionSet == null || connectionSet.isEmpty())) {
                    ++this.isNullTimes;
                    return null;
                }
                this.harvestMbean(nn, connectionSet);
            }
            if ((result = this.doHarvest()).size() > 0) {
                return result;
            }
        }
        catch (Exception e) {
            Level level = Level.SEVERE;
            if (this.hasException) {
                level = Level.FINE;
            }
            LOGGER.log(level, "tomcat harvest:" + e.getMessage() + ",type:" + e.getClass().getName(), (Throwable)e);
            this.hasException = true;
        }
        return null;
    }

    private void harvestMbean(Set<ObjectName> nn, Set<ObjectName> connectionSet) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        TomcatHttpObject ho;
        String name;
        if (nn != null && !nn.isEmpty()) {
            for (ObjectName on : nn) {
                name = on.getKeyProperty("name");
                ho = this.map.get(name);
                if (ho == null) {
                    ho = new TomcatHttpObject();
                    ho.setHttpObjectName(on);
                    this.map.put(name, ho);
                    continue;
                }
                ho.setHttpObjectName(on);
            }
        }
        if (connectionSet != null && !connectionSet.isEmpty()) {
            for (ObjectName connection : connectionSet) {
                name = (String)this.server.getAttribute(connection, "name");
                ho = this.map.get(name);
                if (ho == null) {
                    ho = new TomcatHttpObject();
                    ho.setConnectionObjectName(connection);
                    this.map.put(name, ho);
                    continue;
                }
                ho.setConnectionObjectName(connection);
            }
        }
    }

    private List<MonitorDataRow> doHarvest() throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        ArrayList<MonitorDataRow> result = new ArrayList<MonitorDataRow>();
        for (Map.Entry<String, TomcatHttpObject> entry : this.map.entrySet()) {
            TomcatHttpObject tomcatHttpObject = entry.getValue();
            String name = entry.getKey();
            MonitorDataRow row = new MonitorDataRow();
            row.put((Object)"name", (Object)name);
            this.harvestThreadData(tomcatHttpObject, row);
            this.harvestconnectionData(tomcatHttpObject, row);
            result.add(row);
        }
        return result;
    }

    private void harvestThreadData(TomcatHttpObject tomcatHttpObject, MonitorDataRow row) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        Object o = null;
        if (tomcatHttpObject.getHttpObjectName() != null) {
            o = this.server.getAttribute(tomcatHttpObject.getHttpObjectName(), "currentThreadsBusy");
            if (o != null) {
                int i = Integer.parseInt(o.toString());
                row.put((Object)"currentThreadsBusy", (Object)i);
                int max = tomcatHttpObject.getCurrentThreadsBusyMax().getAndSet(0);
                if (i > max) {
                    row.put((Object)"currentThreadsBusyMax", (Object)i);
                } else {
                    row.put((Object)"currentThreadsBusyMax", (Object)max);
                }
            }
            if ((o = this.server.getAttribute(tomcatHttpObject.getHttpObjectName(), "currentThreadCount")) != null) {
                row.put((Object)"currentThreadCount", (Object)Integer.parseInt(o.toString()));
            }
            if ((o = this.server.getAttribute(tomcatHttpObject.getHttpObjectName(), "maxThreads")) != null) {
                row.put((Object)"maxThreads", (Object)Integer.parseInt(o.toString()));
            }
        }
    }

    public List<MonitorDataRow> getAllStatus() {
        return null;
    }

    private void harvestconnectionData(TomcatHttpObject tomcatHttpObject, MonitorDataRow row) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        Object o = null;
        if (tomcatHttpObject.getConnectionObjectName() != null) {
            o = this.server.getAttribute(tomcatHttpObject.getConnectionObjectName(), "maxConnections");
            if (o != null) {
                row.put((Object)"maxConnections", (Object)Integer.parseInt(o.toString()));
            }
            if ((o = this.server.getAttribute(tomcatHttpObject.getConnectionObjectName(), "connectionCount")) != null) {
                int i = Integer.parseInt(o.toString());
                row.put((Object)"connectionCount", (Object)i);
                int max = tomcatHttpObject.getCurrentConnectionMax().getAndSet(0);
                if (i > max) {
                    row.put((Object)"connectionCountMax", (Object)i);
                } else {
                    row.put((Object)"connectionCountMax", (Object)max);
                }
            }
        }
    }

    public Map<String, List<MonitorDataRow>> afterHarvest(List<MonitorDataRow> collected) {
        return null;
    }

    public void update() {
        if (this.map.size() == 0) {
            return;
        }
        try {
            for (TomcatHttpObject tomcatHttpObject : this.map.values()) {
                Object connection;
                int i;
                Object o;
                if (tomcatHttpObject.getHttpObjectName() != null && (o = this.server.getAttribute(tomcatHttpObject.getHttpObjectName(), "currentThreadsBusy")) != null) {
                    i = Integer.parseInt(o.toString());
                    ConcurrentUtil.setMaxValue((AtomicInteger)tomcatHttpObject.getCurrentThreadsBusyMax(), (int)i);
                }
                if (tomcatHttpObject.getConnectionObjectName() == null || (connection = this.server.getAttribute(tomcatHttpObject.getConnectionObjectName(), "connectionCount")) == null) continue;
                i = Integer.parseInt(connection.toString());
                ConcurrentUtil.setMaxValue((AtomicInteger)tomcatHttpObject.getCurrentConnectionMax(), (int)i);
            }
        }
        catch (Exception e) {
            Level level = Level.SEVERE;
            if (this.hasException) {
                level = Level.FINE;
            }
            LOGGER.log(level, "tomcat harvest:" + e.getMessage() + ",type:" + e.getClass().getName(), (Throwable)e);
            this.hasException = true;
        }
    }

    public void parseParameters(Map<String, String> parameters) {
    }

    public MonitorDataRow getStatus(Map<String, String> primaryKeyMap) {
        return null;
    }

    public void clear() {
    }
}

