/*
 * Decompiled with CFR 0.152.
 */
package com.lubanops.apm.plugin.hbase.interceptor;

import com.lubanops.apm.bootstrap.Interceptor;
import com.lubanops.apm.bootstrap.log.Level;
import com.lubanops.apm.bootstrap.log.LogFactory;
import com.lubanops.apm.bootstrap.trace.SpanEvent;
import com.lubanops.apm.bootstrap.trace.TraceCollector;
import com.lubanops.apm.plugin.hbase.HBaseUtils;
import com.lubanops.apm.plugin.hbase.collector.HBaseCollector;
import java.util.List;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Row;
import org.apache.hadoop.hbase.client.RowMutations;

public class BatchInterceptor
implements Interceptor {
    public Object[] onStart(Object object, Object[] args, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                HTable table = (HTable)object;
                String tableNameWithNamespace = HBaseUtils.getTableNameWithNamespace(table);
                List actions = (List)args[0];
                String parsedActions = HBaseUtils.parseBatchRowList(actions);
                HBaseCollector.onStart(tableNameWithNamespace, parsedActions);
                SpanEvent spanEvent = TraceCollector.onStart((String)className, (String)methodName, (String)"HBase");
                if (spanEvent != null) {
                    spanEvent.addTag("Table Name", tableNameWithNamespace);
                    spanEvent.addTag("Command", parsedActions);
                }
            }
        }
        catch (Exception getException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getException);
        }
        return new Object[0];
    }

    public void onError(Object object, Object[] args, Throwable e, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                TraceCollector.onError((Throwable)e);
                HBaseCollector.onRequestError(TraceCollector.getTraceId());
                HBaseCollector.onException(e);
            }
        }
        catch (Exception getException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getException);
        }
    }

    public void onFinally(Object object, Object[] args, Object result, String className, String methodName) {
        try {
            if (HBaseCollector.INSTANCE.isEnable()) {
                List actions = (List)args[0];
                Object[] results = (Object[])args[1];
                int size = actions.size();
                int queryRowCount = 0;
                int updateRowCount = 0;
                for (int i = 0; i < size; ++i) {
                    Row row = (Row)actions.get(i);
                    if (row instanceof Get) {
                        if (!(results[i] instanceof Result) || ((Result)results[i]).isEmpty()) continue;
                        ++queryRowCount;
                        continue;
                    }
                    if (!(row instanceof Mutation) && !(row instanceof RowMutations) || !(results[i] instanceof Result)) continue;
                    ++updateRowCount;
                }
                SpanEvent spanEvent = TraceCollector.getSpanEvent();
                HBaseCollector.incrementQueryRowCount(queryRowCount);
                HBaseCollector.incrementUpdateRowCount(updateRowCount);
                if (spanEvent != null) {
                    if (queryRowCount > 0) {
                        spanEvent.addTag("Rows Queried", String.valueOf(queryRowCount));
                    }
                    if (updateRowCount > 0) {
                        spanEvent.addTag("Rows Updated", String.valueOf(updateRowCount));
                    }
                }
                HBaseCollector.onFinally();
                TraceCollector.onFinally();
            }
        }
        catch (Exception getException) {
            LogFactory.getLogger().log(Level.SEVERE, "", (Throwable)getException);
        }
    }
}

